<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://pcmiler.alk.com/APIs/SOAP/v1.0/service.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://pcmiler.alk.com/APIs/SOAP/v1.0/service.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Pcm\PcmClassMap::get(),
);
/**
 * Samples for About ServiceType
 */
$about = new \Pcm\ServiceType\PcmAbout($options);
$about->setSoapHeaderAuthHeader(new \Pcm\StructType\PcmAuthHeader());
/**
 * Sample call for AboutService operation/method
 */
if ($about->AboutService(new \Pcm\StructType\PcmAboutService()) !== false) {
    print_r($about->getResult());
} else {
    print_r($about->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \Pcm\ServiceType\PcmProcess($options);
$process->setSoapHeaderAuthHeader(new \Pcm\StructType\PcmAuthHeader());
/**
 * Sample call for ProcessGeocode operation/method
 */
if ($process->ProcessGeocode(new \Pcm\StructType\PcmProcessGeocode()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessReverseGeocode operation/method
 */
if ($process->ProcessReverseGeocode(new \Pcm\StructType\PcmProcessReverseGeocode()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessRadiusSearch operation/method
 */
if ($process->ProcessRadiusSearch(new \Pcm\StructType\PcmProcessRadiusSearch()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessStates operation/method
 */
if ($process->ProcessStates(new \Pcm\StructType\PcmProcessStates()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessMap operation/method
 */
if ($process->ProcessMap(new \Pcm\StructType\PcmProcessMap()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Pcm\ServiceType\PcmGet($options);
$get->setSoapHeaderAuthHeader(new \Pcm\StructType\PcmAuthHeader());
/**
 * Sample call for GetAvoidFavor operation/method
 */
if ($get->GetAvoidFavor(new \Pcm\StructType\PcmGetAvoidFavor()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomPlaces operation/method
 */
if ($get->GetCustomPlaces(new \Pcm\StructType\PcmGetCustomPlaces()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRoadSpeeds operation/method
 */
if ($get->GetRoadSpeeds(new \Pcm\StructType\PcmGetRoadSpeeds()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetETAOutOfRouteReport operation/method
 */
if ($get->GetETAOutOfRouteReport(new \Pcm\StructType\PcmGetETAOutOfRouteReport()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReports operation/method
 */
if ($get->GetReports(new \Pcm\StructType\PcmGetReports()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReportsLegacy operation/method
 */
if ($get->GetReportsLegacy(new \Pcm\StructType\PcmGetReportsLegacy()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPoisAlongRoute operation/method
 */
if ($get->GetPoisAlongRoute(new \Pcm\StructType\PcmGetPoisAlongRoute()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvoidFavorSets operation/method
 */
if ($get->GetAvoidFavorSets(new \Pcm\StructType\PcmGetAvoidFavorSets()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWeatherAlerts operation/method
 */
if ($get->GetWeatherAlerts(new \Pcm\StructType\PcmGetWeatherAlerts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRouteMatrix operation/method
 */
if ($get->GetRouteMatrix(new \Pcm\StructType\PcmGetRouteMatrix()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \Pcm\ServiceType\PcmSet($options);
$set->setSoapHeaderAuthHeader(new \Pcm\StructType\PcmAuthHeader());
/**
 * Sample call for SetAvoidFavor operation/method
 */
if ($set->SetAvoidFavor(new \Pcm\StructType\PcmSetAvoidFavor()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomPlaces operation/method
 */
if ($set->SetCustomPlaces(new \Pcm\StructType\PcmSetCustomPlaces()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetRoadSpeeds operation/method
 */
if ($set->SetRoadSpeeds(new \Pcm\StructType\PcmSetRoadSpeeds()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Reduce ServiceType
 */
$reduce = new \Pcm\ServiceType\PcmReduce($options);
$reduce->setSoapHeaderAuthHeader(new \Pcm\StructType\PcmAuthHeader());
/**
 * Sample call for ReduceTrip operation/method
 */
if ($reduce->ReduceTrip(new \Pcm\StructType\PcmReduceTrip()) !== false) {
    print_r($reduce->getResult());
} else {
    print_r($reduce->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \Pcm\ServiceType\PcmCreate($options);
$create->setSoapHeaderAuthHeader(new \Pcm\StructType\PcmAuthHeader());
/**
 * Sample call for CreateRouteSyncMessage operation/method
 */
if ($create->CreateRouteSyncMessage(new \Pcm\StructType\PcmCreateRouteSyncMessage()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateTripInsightMessage operation/method
 */
if ($create->CreateTripInsightMessage(new \Pcm\StructType\PcmCreateTripInsightMessage()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \Pcm\ServiceType\PcmGenerate($options);
$generate->setSoapHeaderAuthHeader(new \Pcm\StructType\PcmAuthHeader());
/**
 * Sample call for GenerateDriveTimePolygon operation/method
 */
if ($generate->GenerateDriveTimePolygon(new \Pcm\StructType\PcmGenerateDriveTimePolygon()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \Pcm\ServiceType\PcmImport($options);
$import->setSoapHeaderAuthHeader(new \Pcm\StructType\PcmAuthHeader());
/**
 * Sample call for ImportAvoidFavorSet operation/method
 */
if ($import->ImportAvoidFavorSet(new \Pcm\StructType\PcmImportAvoidFavorSet()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
