<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TruckConfig StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TruckConfig
 * @package Pcm
 * @subpackage Structs
 */
class PcmTruckConfig extends AbstractStructBase
{
    /**
     * The Axles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Axles;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Height;
    /**
     * The LCV
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LCV;
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Length;
    /**
     * The Units
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Units;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Weight;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Width;
    /**
     * Constructor method for TruckConfig
     * @uses PcmTruckConfig::setAxles()
     * @uses PcmTruckConfig::setHeight()
     * @uses PcmTruckConfig::setLCV()
     * @uses PcmTruckConfig::setLength()
     * @uses PcmTruckConfig::setUnits()
     * @uses PcmTruckConfig::setWeight()
     * @uses PcmTruckConfig::setWidth()
     * @param int $axles
     * @param string $height
     * @param bool $lCV
     * @param string $length
     * @param string $units
     * @param string $weight
     * @param string $width
     */
    public function __construct($axles = null, $height = null, $lCV = null, $length = null, $units = null, $weight = null, $width = null)
    {
        $this
            ->setAxles($axles)
            ->setHeight($height)
            ->setLCV($lCV)
            ->setLength($length)
            ->setUnits($units)
            ->setWeight($weight)
            ->setWidth($width);
    }
    /**
     * Get Axles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAxles()
    {
        return isset($this->Axles) ? $this->Axles : null;
    }
    /**
     * Set Axles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $axles
     * @return \Pcm\StructType\PcmTruckConfig
     */
    public function setAxles($axles = null)
    {
        // validation for constraint: int
        if (!is_null($axles) && !is_numeric($axles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($axles)), __LINE__);
        }
        if (is_null($axles) || (is_array($axles) && empty($axles))) {
            unset($this->Axles);
        } else {
            $this->Axles = $axles;
        }
        return $this;
    }
    /**
     * Get Height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeight()
    {
        return isset($this->Height) ? $this->Height : null;
    }
    /**
     * Set Height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $height
     * @return \Pcm\StructType\PcmTruckConfig
     */
    public function setHeight($height = null)
    {
        // validation for constraint: string
        if (!is_null($height) && !is_string($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($height)), __LINE__);
        }
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->Height);
        } else {
            $this->Height = $height;
        }
        return $this;
    }
    /**
     * Get LCV value
     * @return bool|null
     */
    public function getLCV()
    {
        return $this->LCV;
    }
    /**
     * Set LCV value
     * @param bool $lCV
     * @return \Pcm\StructType\PcmTruckConfig
     */
    public function setLCV($lCV = null)
    {
        // validation for constraint: boolean
        if (!is_null($lCV) && !is_bool($lCV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lCV)), __LINE__);
        }
        $this->LCV = $lCV;
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $length
     * @return \Pcm\StructType\PcmTruckConfig
     */
    public function setLength($length = null)
    {
        // validation for constraint: string
        if (!is_null($length) && !is_string($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($length)), __LINE__);
        }
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get Units value
     * @return string|null
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @uses \Pcm\EnumType\PcmVehicleDimUnits::valueIsValid()
     * @uses \Pcm\EnumType\PcmVehicleDimUnits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $units
     * @return \Pcm\StructType\PcmTruckConfig
     */
    public function setUnits($units = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmVehicleDimUnits::valueIsValid($units)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $units, implode(', ', \Pcm\EnumType\PcmVehicleDimUnits::getValidValues())), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $weight
     * @return \Pcm\StructType\PcmTruckConfig
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $width
     * @return \Pcm\StructType\PcmTruckConfig
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($width)), __LINE__);
        }
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmTruckConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
