<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadSpeed StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoadSpeed
 * @package Pcm
 * @subpackage Structs
 */
class PcmRoadSpeed extends PcmRoadSpeedBase
{
    /**
     * The Jurisdiction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Jurisdiction;
    /**
     * Constructor method for RoadSpeed
     * @uses PcmRoadSpeed::setJurisdiction()
     * @param string $jurisdiction
     */
    public function __construct($jurisdiction = null)
    {
        $this
            ->setJurisdiction($jurisdiction);
    }
    /**
     * Get Jurisdiction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJurisdiction()
    {
        return isset($this->Jurisdiction) ? $this->Jurisdiction : null;
    }
    /**
     * Set Jurisdiction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jurisdiction
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public function setJurisdiction($jurisdiction = null)
    {
        // validation for constraint: string
        if (!is_null($jurisdiction) && !is_string($jurisdiction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurisdiction)), __LINE__);
        }
        if (is_null($jurisdiction) || (is_array($jurisdiction) && empty($jurisdiction))) {
            unset($this->Jurisdiction);
        } else {
            $this->Jurisdiction = $jurisdiction;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRoadSpeed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
