<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RadiusSearchRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RadiusSearchRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmRadiusSearchRequestBody extends AbstractStructBase
{
    /**
     * The CenterPoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmLocation
     */
    public $CenterPoint;
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmDistance
     */
    public $Radius;
    /**
     * The POICategories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $POICategories;
    /**
     * The NameFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameFilter;
    /**
     * The RetrievePoiIDs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RetrievePoiIDs;
    /**
     * Constructor method for RadiusSearchRequestBody
     * @uses PcmRadiusSearchRequestBody::setCenterPoint()
     * @uses PcmRadiusSearchRequestBody::setRadius()
     * @uses PcmRadiusSearchRequestBody::setPOICategories()
     * @uses PcmRadiusSearchRequestBody::setNameFilter()
     * @uses PcmRadiusSearchRequestBody::setRetrievePoiIDs()
     * @param \Pcm\StructType\PcmLocation $centerPoint
     * @param \Pcm\StructType\PcmDistance $radius
     * @param string $pOICategories
     * @param string $nameFilter
     * @param bool $retrievePoiIDs
     */
    public function __construct(\Pcm\StructType\PcmLocation $centerPoint = null, \Pcm\StructType\PcmDistance $radius = null, $pOICategories = null, $nameFilter = null, $retrievePoiIDs = null)
    {
        $this
            ->setCenterPoint($centerPoint)
            ->setRadius($radius)
            ->setPOICategories($pOICategories)
            ->setNameFilter($nameFilter)
            ->setRetrievePoiIDs($retrievePoiIDs);
    }
    /**
     * Get CenterPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmLocation|null
     */
    public function getCenterPoint()
    {
        return isset($this->CenterPoint) ? $this->CenterPoint : null;
    }
    /**
     * Set CenterPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmLocation $centerPoint
     * @return \Pcm\StructType\PcmRadiusSearchRequestBody
     */
    public function setCenterPoint(\Pcm\StructType\PcmLocation $centerPoint = null)
    {
        if (is_null($centerPoint) || (is_array($centerPoint) && empty($centerPoint))) {
            unset($this->CenterPoint);
        } else {
            $this->CenterPoint = $centerPoint;
        }
        return $this;
    }
    /**
     * Get Radius value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmDistance|null
     */
    public function getRadius()
    {
        return isset($this->Radius) ? $this->Radius : null;
    }
    /**
     * Set Radius value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmDistance $radius
     * @return \Pcm\StructType\PcmRadiusSearchRequestBody
     */
    public function setRadius(\Pcm\StructType\PcmDistance $radius = null)
    {
        if (is_null($radius) || (is_array($radius) && empty($radius))) {
            unset($this->Radius);
        } else {
            $this->Radius = $radius;
        }
        return $this;
    }
    /**
     * Get POICategories value
     * @return string|null
     */
    public function getPOICategories()
    {
        return $this->POICategories;
    }
    /**
     * Set POICategories value
     * @uses \Pcm\EnumType\PcmPOIType::valueIsValid()
     * @uses \Pcm\EnumType\PcmPOIType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pOICategories
     * @return \Pcm\StructType\PcmRadiusSearchRequestBody
     */
    public function setPOICategories($pOICategories = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPOIType::valueIsValid($pOICategories)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pOICategories, implode(', ', \Pcm\EnumType\PcmPOIType::getValidValues())), __LINE__);
        }
        $this->POICategories = $pOICategories;
        return $this;
    }
    /**
     * Get NameFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameFilter()
    {
        return isset($this->NameFilter) ? $this->NameFilter : null;
    }
    /**
     * Set NameFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameFilter
     * @return \Pcm\StructType\PcmRadiusSearchRequestBody
     */
    public function setNameFilter($nameFilter = null)
    {
        // validation for constraint: string
        if (!is_null($nameFilter) && !is_string($nameFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameFilter)), __LINE__);
        }
        if (is_null($nameFilter) || (is_array($nameFilter) && empty($nameFilter))) {
            unset($this->NameFilter);
        } else {
            $this->NameFilter = $nameFilter;
        }
        return $this;
    }
    /**
     * Get RetrievePoiIDs value
     * @return bool|null
     */
    public function getRetrievePoiIDs()
    {
        return $this->RetrievePoiIDs;
    }
    /**
     * Set RetrievePoiIDs value
     * @param bool $retrievePoiIDs
     * @return \Pcm\StructType\PcmRadiusSearchRequestBody
     */
    public function setRetrievePoiIDs($retrievePoiIDs = null)
    {
        // validation for constraint: boolean
        if (!is_null($retrievePoiIDs) && !is_bool($retrievePoiIDs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retrievePoiIDs)), __LINE__);
        }
        $this->RetrievePoiIDs = $retrievePoiIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRadiusSearchRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
