<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessStates StructType
 * @package Pcm
 * @subpackage Structs
 */
class PcmProcessStates extends AbstractStructBase
{
    /**
     * The Request
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmGetStatesRequest
     */
    public $Request;
    /**
     * Constructor method for ProcessStates
     * @uses PcmProcessStates::setRequest()
     * @param \Pcm\StructType\PcmGetStatesRequest $request
     */
    public function __construct(\Pcm\StructType\PcmGetStatesRequest $request = null)
    {
        $this
            ->setRequest($request);
    }
    /**
     * Get Request value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmGetStatesRequest|null
     */
    public function getRequest()
    {
        return isset($this->Request) ? $this->Request : null;
    }
    /**
     * Set Request value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmGetStatesRequest $request
     * @return \Pcm\StructType\PcmProcessStates
     */
    public function setRequest(\Pcm\StructType\PcmGetStatesRequest $request = null)
    {
        if (is_null($request) || (is_array($request) && empty($request))) {
            unset($this->Request);
        } else {
            $this->Request = $request;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmProcessStates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
