<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PoisAlongRouteRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PoisAlongRouteRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmPoisAlongRouteRequestBody extends AbstractStructBase
{
    /**
     * The PoiRoute
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmExtendedRoute
     */
    public $PoiRoute;
    /**
     * The RouteLegIndex
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RouteLegIndex;
    /**
     * The SearchType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchType;
    /**
     * The GenericPOICategories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfPOIGenericType
     */
    public $GenericPOICategories;
    /**
     * The HoSPOICategories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfPOIHosType
     */
    public $HoSPOICategories;
    /**
     * The SearchWindowUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchWindowUnits;
    /**
     * The SearchWindowStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SearchWindowStart;
    /**
     * The SearchWindowEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SearchWindowEnd;
    /**
     * The AirDistanceThreshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AirDistanceThreshold;
    /**
     * Constructor method for PoisAlongRouteRequestBody
     * @uses PcmPoisAlongRouteRequestBody::setPoiRoute()
     * @uses PcmPoisAlongRouteRequestBody::setRouteLegIndex()
     * @uses PcmPoisAlongRouteRequestBody::setSearchType()
     * @uses PcmPoisAlongRouteRequestBody::setGenericPOICategories()
     * @uses PcmPoisAlongRouteRequestBody::setHoSPOICategories()
     * @uses PcmPoisAlongRouteRequestBody::setSearchWindowUnits()
     * @uses PcmPoisAlongRouteRequestBody::setSearchWindowStart()
     * @uses PcmPoisAlongRouteRequestBody::setSearchWindowEnd()
     * @uses PcmPoisAlongRouteRequestBody::setAirDistanceThreshold()
     * @param \Pcm\StructType\PcmExtendedRoute $poiRoute
     * @param int $routeLegIndex
     * @param string $searchType
     * @param \Pcm\ArrayType\PcmArrayOfPOIGenericType $genericPOICategories
     * @param \Pcm\ArrayType\PcmArrayOfPOIHosType $hoSPOICategories
     * @param string $searchWindowUnits
     * @param float $searchWindowStart
     * @param float $searchWindowEnd
     * @param float $airDistanceThreshold
     */
    public function __construct(\Pcm\StructType\PcmExtendedRoute $poiRoute = null, $routeLegIndex = null, $searchType = null, \Pcm\ArrayType\PcmArrayOfPOIGenericType $genericPOICategories = null, \Pcm\ArrayType\PcmArrayOfPOIHosType $hoSPOICategories = null, $searchWindowUnits = null, $searchWindowStart = null, $searchWindowEnd = null, $airDistanceThreshold = null)
    {
        $this
            ->setPoiRoute($poiRoute)
            ->setRouteLegIndex($routeLegIndex)
            ->setSearchType($searchType)
            ->setGenericPOICategories($genericPOICategories)
            ->setHoSPOICategories($hoSPOICategories)
            ->setSearchWindowUnits($searchWindowUnits)
            ->setSearchWindowStart($searchWindowStart)
            ->setSearchWindowEnd($searchWindowEnd)
            ->setAirDistanceThreshold($airDistanceThreshold);
    }
    /**
     * Get PoiRoute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmExtendedRoute|null
     */
    public function getPoiRoute()
    {
        return isset($this->PoiRoute) ? $this->PoiRoute : null;
    }
    /**
     * Set PoiRoute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmExtendedRoute $poiRoute
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setPoiRoute(\Pcm\StructType\PcmExtendedRoute $poiRoute = null)
    {
        if (is_null($poiRoute) || (is_array($poiRoute) && empty($poiRoute))) {
            unset($this->PoiRoute);
        } else {
            $this->PoiRoute = $poiRoute;
        }
        return $this;
    }
    /**
     * Get RouteLegIndex value
     * @return int|null
     */
    public function getRouteLegIndex()
    {
        return $this->RouteLegIndex;
    }
    /**
     * Set RouteLegIndex value
     * @param int $routeLegIndex
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setRouteLegIndex($routeLegIndex = null)
    {
        // validation for constraint: int
        if (!is_null($routeLegIndex) && !is_numeric($routeLegIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($routeLegIndex)), __LINE__);
        }
        $this->RouteLegIndex = $routeLegIndex;
        return $this;
    }
    /**
     * Get SearchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->SearchType;
    }
    /**
     * Set SearchType value
     * @uses \Pcm\EnumType\PcmPOISearchType::valueIsValid()
     * @uses \Pcm\EnumType\PcmPOISearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPOISearchType::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType, implode(', ', \Pcm\EnumType\PcmPOISearchType::getValidValues())), __LINE__);
        }
        $this->SearchType = $searchType;
        return $this;
    }
    /**
     * Get GenericPOICategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfPOIGenericType|null
     */
    public function getGenericPOICategories()
    {
        return isset($this->GenericPOICategories) ? $this->GenericPOICategories : null;
    }
    /**
     * Set GenericPOICategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfPOIGenericType $genericPOICategories
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setGenericPOICategories(\Pcm\ArrayType\PcmArrayOfPOIGenericType $genericPOICategories = null)
    {
        if (is_null($genericPOICategories) || (is_array($genericPOICategories) && empty($genericPOICategories))) {
            unset($this->GenericPOICategories);
        } else {
            $this->GenericPOICategories = $genericPOICategories;
        }
        return $this;
    }
    /**
     * Get HoSPOICategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfPOIHosType|null
     */
    public function getHoSPOICategories()
    {
        return isset($this->HoSPOICategories) ? $this->HoSPOICategories : null;
    }
    /**
     * Set HoSPOICategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfPOIHosType $hoSPOICategories
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setHoSPOICategories(\Pcm\ArrayType\PcmArrayOfPOIHosType $hoSPOICategories = null)
    {
        if (is_null($hoSPOICategories) || (is_array($hoSPOICategories) && empty($hoSPOICategories))) {
            unset($this->HoSPOICategories);
        } else {
            $this->HoSPOICategories = $hoSPOICategories;
        }
        return $this;
    }
    /**
     * Get SearchWindowUnits value
     * @return string|null
     */
    public function getSearchWindowUnits()
    {
        return $this->SearchWindowUnits;
    }
    /**
     * Set SearchWindowUnits value
     * @uses \Pcm\EnumType\PcmPoiSearchWindowUnits::valueIsValid()
     * @uses \Pcm\EnumType\PcmPoiSearchWindowUnits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchWindowUnits
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setSearchWindowUnits($searchWindowUnits = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPoiSearchWindowUnits::valueIsValid($searchWindowUnits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchWindowUnits, implode(', ', \Pcm\EnumType\PcmPoiSearchWindowUnits::getValidValues())), __LINE__);
        }
        $this->SearchWindowUnits = $searchWindowUnits;
        return $this;
    }
    /**
     * Get SearchWindowStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSearchWindowStart()
    {
        return isset($this->SearchWindowStart) ? $this->SearchWindowStart : null;
    }
    /**
     * Set SearchWindowStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $searchWindowStart
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setSearchWindowStart($searchWindowStart = null)
    {
        if (is_null($searchWindowStart) || (is_array($searchWindowStart) && empty($searchWindowStart))) {
            unset($this->SearchWindowStart);
        } else {
            $this->SearchWindowStart = $searchWindowStart;
        }
        return $this;
    }
    /**
     * Get SearchWindowEnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSearchWindowEnd()
    {
        return isset($this->SearchWindowEnd) ? $this->SearchWindowEnd : null;
    }
    /**
     * Set SearchWindowEnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $searchWindowEnd
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setSearchWindowEnd($searchWindowEnd = null)
    {
        if (is_null($searchWindowEnd) || (is_array($searchWindowEnd) && empty($searchWindowEnd))) {
            unset($this->SearchWindowEnd);
        } else {
            $this->SearchWindowEnd = $searchWindowEnd;
        }
        return $this;
    }
    /**
     * Get AirDistanceThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAirDistanceThreshold()
    {
        return isset($this->AirDistanceThreshold) ? $this->AirDistanceThreshold : null;
    }
    /**
     * Set AirDistanceThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $airDistanceThreshold
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public function setAirDistanceThreshold($airDistanceThreshold = null)
    {
        if (is_null($airDistanceThreshold) || (is_array($airDistanceThreshold) && empty($airDistanceThreshold))) {
            unset($this->AirDistanceThreshold);
        } else {
            $this->AirDistanceThreshold = $airDistanceThreshold;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmPoisAlongRouteRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
