<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Point StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Point
 * @package Pcm
 * @subpackage Structs
 */
class PcmPoint extends AbstractStructBase
{
    /**
     * The X
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $X;
    /**
     * The Y
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Y;
    /**
     * Constructor method for Point
     * @uses PcmPoint::setX()
     * @uses PcmPoint::setY()
     * @param int $x
     * @param int $y
     */
    public function __construct($x = null, $y = null)
    {
        $this
            ->setX($x)
            ->setY($y);
    }
    /**
     * Get X value
     * @return int|null
     */
    public function getX()
    {
        return $this->X;
    }
    /**
     * Set X value
     * @param int $x
     * @return \Pcm\StructType\PcmPoint
     */
    public function setX($x = null)
    {
        // validation for constraint: int
        if (!is_null($x) && !is_numeric($x)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($x)), __LINE__);
        }
        $this->X = $x;
        return $this;
    }
    /**
     * Get Y value
     * @return int|null
     */
    public function getY()
    {
        return $this->Y;
    }
    /**
     * Set Y value
     * @param int $y
     * @return \Pcm\StructType\PcmPoint
     */
    public function setY($y = null)
    {
        // validation for constraint: int
        if (!is_null($y) && !is_numeric($y)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($y)), __LINE__);
        }
        $this->Y = $y;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
