<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Legend StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Legend
 * @package Pcm
 * @subpackage Structs
 */
class PcmLegend extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The DrawOnMap
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DrawOnMap;
    /**
     * Constructor method for Legend
     * @uses PcmLegend::setType()
     * @uses PcmLegend::setDrawOnMap()
     * @param string $type
     * @param bool $drawOnMap
     */
    public function __construct($type = null, $drawOnMap = null)
    {
        $this
            ->setType($type)
            ->setDrawOnMap($drawOnMap);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Pcm\EnumType\PcmLegendType::valueIsValid()
     * @uses \Pcm\EnumType\PcmLegendType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pcm\StructType\PcmLegend
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmLegendType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \Pcm\EnumType\PcmLegendType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get DrawOnMap value
     * @return bool|null
     */
    public function getDrawOnMap()
    {
        return $this->DrawOnMap;
    }
    /**
     * Set DrawOnMap value
     * @param bool $drawOnMap
     * @return \Pcm\StructType\PcmLegend
     */
    public function setDrawOnMap($drawOnMap = null)
    {
        // validation for constraint: boolean
        if (!is_null($drawOnMap) && !is_bool($drawOnMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($drawOnMap)), __LINE__);
        }
        $this->DrawOnMap = $drawOnMap;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmLegend
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
