<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HoursOfServiceRemaining StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HoursOfServiceRemaining
 * @package Pcm
 * @subpackage Structs
 */
class PcmHoursOfServiceRemaining extends AbstractStructBase
{
    /**
     * The Enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The RemainingDriveTimeUntilBreak
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingDriveTimeUntilBreak;
    /**
     * The RemainingDriveTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingDriveTime;
    /**
     * The RemainingOnDutyTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingOnDutyTime;
    /**
     * The HoSRuleType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HoSRuleType;
    /**
     * The RemainingCycleDutyTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingCycleDutyTime;
    /**
     * The CycleTimeGains
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfdouble
     */
    public $CycleTimeGains;
    /**
     * The LastCycleResetDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastCycleResetDateTime;
    /**
     * The Last24HourBreakDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Last24HourBreakDateTime;
    /**
     * The RemainingCanadaOnDutyTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingCanadaOnDutyTime;
    /**
     * Constructor method for HoursOfServiceRemaining
     * @uses PcmHoursOfServiceRemaining::setEnabled()
     * @uses PcmHoursOfServiceRemaining::setRemainingDriveTimeUntilBreak()
     * @uses PcmHoursOfServiceRemaining::setRemainingDriveTime()
     * @uses PcmHoursOfServiceRemaining::setRemainingOnDutyTime()
     * @uses PcmHoursOfServiceRemaining::setHoSRuleType()
     * @uses PcmHoursOfServiceRemaining::setRemainingCycleDutyTime()
     * @uses PcmHoursOfServiceRemaining::setCycleTimeGains()
     * @uses PcmHoursOfServiceRemaining::setLastCycleResetDateTime()
     * @uses PcmHoursOfServiceRemaining::setLast24HourBreakDateTime()
     * @uses PcmHoursOfServiceRemaining::setRemainingCanadaOnDutyTime()
     * @param bool $enabled
     * @param float $remainingDriveTimeUntilBreak
     * @param float $remainingDriveTime
     * @param float $remainingOnDutyTime
     * @param string $hoSRuleType
     * @param float $remainingCycleDutyTime
     * @param \Pcm\ArrayType\PcmArrayOfdouble $cycleTimeGains
     * @param string $lastCycleResetDateTime
     * @param string $last24HourBreakDateTime
     * @param float $remainingCanadaOnDutyTime
     */
    public function __construct($enabled = null, $remainingDriveTimeUntilBreak = null, $remainingDriveTime = null, $remainingOnDutyTime = null, $hoSRuleType = null, $remainingCycleDutyTime = null, \Pcm\ArrayType\PcmArrayOfdouble $cycleTimeGains = null, $lastCycleResetDateTime = null, $last24HourBreakDateTime = null, $remainingCanadaOnDutyTime = null)
    {
        $this
            ->setEnabled($enabled)
            ->setRemainingDriveTimeUntilBreak($remainingDriveTimeUntilBreak)
            ->setRemainingDriveTime($remainingDriveTime)
            ->setRemainingOnDutyTime($remainingOnDutyTime)
            ->setHoSRuleType($hoSRuleType)
            ->setRemainingCycleDutyTime($remainingCycleDutyTime)
            ->setCycleTimeGains($cycleTimeGains)
            ->setLastCycleResetDateTime($lastCycleResetDateTime)
            ->setLast24HourBreakDateTime($last24HourBreakDateTime)
            ->setRemainingCanadaOnDutyTime($remainingCanadaOnDutyTime);
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get RemainingDriveTimeUntilBreak value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingDriveTimeUntilBreak()
    {
        return isset($this->RemainingDriveTimeUntilBreak) ? $this->RemainingDriveTimeUntilBreak : null;
    }
    /**
     * Set RemainingDriveTimeUntilBreak value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingDriveTimeUntilBreak
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setRemainingDriveTimeUntilBreak($remainingDriveTimeUntilBreak = null)
    {
        if (is_null($remainingDriveTimeUntilBreak) || (is_array($remainingDriveTimeUntilBreak) && empty($remainingDriveTimeUntilBreak))) {
            unset($this->RemainingDriveTimeUntilBreak);
        } else {
            $this->RemainingDriveTimeUntilBreak = $remainingDriveTimeUntilBreak;
        }
        return $this;
    }
    /**
     * Get RemainingDriveTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingDriveTime()
    {
        return isset($this->RemainingDriveTime) ? $this->RemainingDriveTime : null;
    }
    /**
     * Set RemainingDriveTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingDriveTime
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setRemainingDriveTime($remainingDriveTime = null)
    {
        if (is_null($remainingDriveTime) || (is_array($remainingDriveTime) && empty($remainingDriveTime))) {
            unset($this->RemainingDriveTime);
        } else {
            $this->RemainingDriveTime = $remainingDriveTime;
        }
        return $this;
    }
    /**
     * Get RemainingOnDutyTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingOnDutyTime()
    {
        return isset($this->RemainingOnDutyTime) ? $this->RemainingOnDutyTime : null;
    }
    /**
     * Set RemainingOnDutyTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingOnDutyTime
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setRemainingOnDutyTime($remainingOnDutyTime = null)
    {
        if (is_null($remainingOnDutyTime) || (is_array($remainingOnDutyTime) && empty($remainingOnDutyTime))) {
            unset($this->RemainingOnDutyTime);
        } else {
            $this->RemainingOnDutyTime = $remainingOnDutyTime;
        }
        return $this;
    }
    /**
     * Get HoSRuleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoSRuleType()
    {
        return isset($this->HoSRuleType) ? $this->HoSRuleType : null;
    }
    /**
     * Set HoSRuleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmHoSScheduleType::valueIsValid()
     * @uses \Pcm\EnumType\PcmHoSScheduleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hoSRuleType
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setHoSRuleType($hoSRuleType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmHoSScheduleType::valueIsValid($hoSRuleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hoSRuleType, implode(', ', \Pcm\EnumType\PcmHoSScheduleType::getValidValues())), __LINE__);
        }
        if (is_null($hoSRuleType) || (is_array($hoSRuleType) && empty($hoSRuleType))) {
            unset($this->HoSRuleType);
        } else {
            $this->HoSRuleType = $hoSRuleType;
        }
        return $this;
    }
    /**
     * Get RemainingCycleDutyTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingCycleDutyTime()
    {
        return isset($this->RemainingCycleDutyTime) ? $this->RemainingCycleDutyTime : null;
    }
    /**
     * Set RemainingCycleDutyTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingCycleDutyTime
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setRemainingCycleDutyTime($remainingCycleDutyTime = null)
    {
        if (is_null($remainingCycleDutyTime) || (is_array($remainingCycleDutyTime) && empty($remainingCycleDutyTime))) {
            unset($this->RemainingCycleDutyTime);
        } else {
            $this->RemainingCycleDutyTime = $remainingCycleDutyTime;
        }
        return $this;
    }
    /**
     * Get CycleTimeGains value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfdouble|null
     */
    public function getCycleTimeGains()
    {
        return isset($this->CycleTimeGains) ? $this->CycleTimeGains : null;
    }
    /**
     * Set CycleTimeGains value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfdouble $cycleTimeGains
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setCycleTimeGains(\Pcm\ArrayType\PcmArrayOfdouble $cycleTimeGains = null)
    {
        if (is_null($cycleTimeGains) || (is_array($cycleTimeGains) && empty($cycleTimeGains))) {
            unset($this->CycleTimeGains);
        } else {
            $this->CycleTimeGains = $cycleTimeGains;
        }
        return $this;
    }
    /**
     * Get LastCycleResetDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastCycleResetDateTime()
    {
        return isset($this->LastCycleResetDateTime) ? $this->LastCycleResetDateTime : null;
    }
    /**
     * Set LastCycleResetDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastCycleResetDateTime
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setLastCycleResetDateTime($lastCycleResetDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastCycleResetDateTime) && !is_string($lastCycleResetDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastCycleResetDateTime)), __LINE__);
        }
        if (is_null($lastCycleResetDateTime) || (is_array($lastCycleResetDateTime) && empty($lastCycleResetDateTime))) {
            unset($this->LastCycleResetDateTime);
        } else {
            $this->LastCycleResetDateTime = $lastCycleResetDateTime;
        }
        return $this;
    }
    /**
     * Get Last24HourBreakDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLast24HourBreakDateTime()
    {
        return isset($this->Last24HourBreakDateTime) ? $this->Last24HourBreakDateTime : null;
    }
    /**
     * Set Last24HourBreakDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $last24HourBreakDateTime
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setLast24HourBreakDateTime($last24HourBreakDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($last24HourBreakDateTime) && !is_string($last24HourBreakDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last24HourBreakDateTime)), __LINE__);
        }
        if (is_null($last24HourBreakDateTime) || (is_array($last24HourBreakDateTime) && empty($last24HourBreakDateTime))) {
            unset($this->Last24HourBreakDateTime);
        } else {
            $this->Last24HourBreakDateTime = $last24HourBreakDateTime;
        }
        return $this;
    }
    /**
     * Get RemainingCanadaOnDutyTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingCanadaOnDutyTime()
    {
        return isset($this->RemainingCanadaOnDutyTime) ? $this->RemainingCanadaOnDutyTime : null;
    }
    /**
     * Set RemainingCanadaOnDutyTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingCanadaOnDutyTime
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public function setRemainingCanadaOnDutyTime($remainingCanadaOnDutyTime = null)
    {
        if (is_null($remainingCanadaOnDutyTime) || (is_array($remainingCanadaOnDutyTime) && empty($remainingCanadaOnDutyTime))) {
            unset($this->RemainingCanadaOnDutyTime);
        } else {
            $this->RemainingCanadaOnDutyTime = $remainingCanadaOnDutyTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmHoursOfServiceRemaining
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
