<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HoursOfServiceOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HoursOfServiceOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmHoursOfServiceOptions extends PcmHoursOfServiceRemaining
{
    /**
     * The UseCycleReset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseCycleReset;
    /**
     * The TerminalDayStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalDayStartTime;
    /**
     * The UseCustomPlaces
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseCustomPlaces;
    /**
     * The TeamDriving
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TeamDriving;
    /**
     * The CustomBreakDurations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmHoursOfServiceBreakDurations
     */
    public $CustomBreakDurations;
    /**
     * The AlternateHoSRuleType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternateHoSRuleType;
    /**
     * The MaxAlternateRestStops
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAlternateRestStops;
    /**
     * Constructor method for HoursOfServiceOptions
     * @uses PcmHoursOfServiceOptions::setUseCycleReset()
     * @uses PcmHoursOfServiceOptions::setTerminalDayStartTime()
     * @uses PcmHoursOfServiceOptions::setUseCustomPlaces()
     * @uses PcmHoursOfServiceOptions::setTeamDriving()
     * @uses PcmHoursOfServiceOptions::setCustomBreakDurations()
     * @uses PcmHoursOfServiceOptions::setAlternateHoSRuleType()
     * @uses PcmHoursOfServiceOptions::setMaxAlternateRestStops()
     * @param bool $useCycleReset
     * @param string $terminalDayStartTime
     * @param bool $useCustomPlaces
     * @param bool $teamDriving
     * @param \Pcm\StructType\PcmHoursOfServiceBreakDurations $customBreakDurations
     * @param string $alternateHoSRuleType
     * @param int $maxAlternateRestStops
     */
    public function __construct($useCycleReset = null, $terminalDayStartTime = null, $useCustomPlaces = null, $teamDriving = null, \Pcm\StructType\PcmHoursOfServiceBreakDurations $customBreakDurations = null, $alternateHoSRuleType = null, $maxAlternateRestStops = null)
    {
        $this
            ->setUseCycleReset($useCycleReset)
            ->setTerminalDayStartTime($terminalDayStartTime)
            ->setUseCustomPlaces($useCustomPlaces)
            ->setTeamDriving($teamDriving)
            ->setCustomBreakDurations($customBreakDurations)
            ->setAlternateHoSRuleType($alternateHoSRuleType)
            ->setMaxAlternateRestStops($maxAlternateRestStops);
    }
    /**
     * Get UseCycleReset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseCycleReset()
    {
        return isset($this->UseCycleReset) ? $this->UseCycleReset : null;
    }
    /**
     * Set UseCycleReset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useCycleReset
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setUseCycleReset($useCycleReset = null)
    {
        // validation for constraint: boolean
        if (!is_null($useCycleReset) && !is_bool($useCycleReset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useCycleReset)), __LINE__);
        }
        if (is_null($useCycleReset) || (is_array($useCycleReset) && empty($useCycleReset))) {
            unset($this->UseCycleReset);
        } else {
            $this->UseCycleReset = $useCycleReset;
        }
        return $this;
    }
    /**
     * Get TerminalDayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalDayStartTime()
    {
        return isset($this->TerminalDayStartTime) ? $this->TerminalDayStartTime : null;
    }
    /**
     * Set TerminalDayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalDayStartTime
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setTerminalDayStartTime($terminalDayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($terminalDayStartTime) && !is_string($terminalDayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalDayStartTime)), __LINE__);
        }
        if (is_null($terminalDayStartTime) || (is_array($terminalDayStartTime) && empty($terminalDayStartTime))) {
            unset($this->TerminalDayStartTime);
        } else {
            $this->TerminalDayStartTime = $terminalDayStartTime;
        }
        return $this;
    }
    /**
     * Get UseCustomPlaces value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseCustomPlaces()
    {
        return isset($this->UseCustomPlaces) ? $this->UseCustomPlaces : null;
    }
    /**
     * Set UseCustomPlaces value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useCustomPlaces
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setUseCustomPlaces($useCustomPlaces = null)
    {
        // validation for constraint: boolean
        if (!is_null($useCustomPlaces) && !is_bool($useCustomPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useCustomPlaces)), __LINE__);
        }
        if (is_null($useCustomPlaces) || (is_array($useCustomPlaces) && empty($useCustomPlaces))) {
            unset($this->UseCustomPlaces);
        } else {
            $this->UseCustomPlaces = $useCustomPlaces;
        }
        return $this;
    }
    /**
     * Get TeamDriving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTeamDriving()
    {
        return isset($this->TeamDriving) ? $this->TeamDriving : null;
    }
    /**
     * Set TeamDriving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $teamDriving
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setTeamDriving($teamDriving = null)
    {
        // validation for constraint: boolean
        if (!is_null($teamDriving) && !is_bool($teamDriving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($teamDriving)), __LINE__);
        }
        if (is_null($teamDriving) || (is_array($teamDriving) && empty($teamDriving))) {
            unset($this->TeamDriving);
        } else {
            $this->TeamDriving = $teamDriving;
        }
        return $this;
    }
    /**
     * Get CustomBreakDurations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmHoursOfServiceBreakDurations|null
     */
    public function getCustomBreakDurations()
    {
        return isset($this->CustomBreakDurations) ? $this->CustomBreakDurations : null;
    }
    /**
     * Set CustomBreakDurations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmHoursOfServiceBreakDurations $customBreakDurations
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setCustomBreakDurations(\Pcm\StructType\PcmHoursOfServiceBreakDurations $customBreakDurations = null)
    {
        if (is_null($customBreakDurations) || (is_array($customBreakDurations) && empty($customBreakDurations))) {
            unset($this->CustomBreakDurations);
        } else {
            $this->CustomBreakDurations = $customBreakDurations;
        }
        return $this;
    }
    /**
     * Get AlternateHoSRuleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateHoSRuleType()
    {
        return isset($this->AlternateHoSRuleType) ? $this->AlternateHoSRuleType : null;
    }
    /**
     * Set AlternateHoSRuleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmHoSScheduleType::valueIsValid()
     * @uses \Pcm\EnumType\PcmHoSScheduleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alternateHoSRuleType
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setAlternateHoSRuleType($alternateHoSRuleType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmHoSScheduleType::valueIsValid($alternateHoSRuleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alternateHoSRuleType, implode(', ', \Pcm\EnumType\PcmHoSScheduleType::getValidValues())), __LINE__);
        }
        if (is_null($alternateHoSRuleType) || (is_array($alternateHoSRuleType) && empty($alternateHoSRuleType))) {
            unset($this->AlternateHoSRuleType);
        } else {
            $this->AlternateHoSRuleType = $alternateHoSRuleType;
        }
        return $this;
    }
    /**
     * Get MaxAlternateRestStops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAlternateRestStops()
    {
        return isset($this->MaxAlternateRestStops) ? $this->MaxAlternateRestStops : null;
    }
    /**
     * Set MaxAlternateRestStops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAlternateRestStops
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public function setMaxAlternateRestStops($maxAlternateRestStops = null)
    {
        // validation for constraint: int
        if (!is_null($maxAlternateRestStops) && !is_numeric($maxAlternateRestStops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAlternateRestStops)), __LINE__);
        }
        if (is_null($maxAlternateRestStops) || (is_array($maxAlternateRestStops) && empty($maxAlternateRestStops))) {
            unset($this->MaxAlternateRestStops);
        } else {
            $this->MaxAlternateRestStops = $maxAlternateRestStops;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
