<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomPlaceSetRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCustomPlaceSetRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmGetCustomPlaceSetRequestBody extends PcmCustomDataSetRequestBody
{
    /**
     * The PlaceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlaceName;
    /**
     * The CategoryId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CategoryId;
    /**
     * The CategoryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryName;
    /**
     * The Corner1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $Corner1;
    /**
     * The Corner2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $Corner2;
    /**
     * The IncludePlaces
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePlaces;
    /**
     * Constructor method for GetCustomPlaceSetRequestBody
     * @uses PcmGetCustomPlaceSetRequestBody::setPlaceName()
     * @uses PcmGetCustomPlaceSetRequestBody::setCategoryId()
     * @uses PcmGetCustomPlaceSetRequestBody::setCategoryName()
     * @uses PcmGetCustomPlaceSetRequestBody::setCorner1()
     * @uses PcmGetCustomPlaceSetRequestBody::setCorner2()
     * @uses PcmGetCustomPlaceSetRequestBody::setIncludePlaces()
     * @param string $placeName
     * @param int $categoryId
     * @param string $categoryName
     * @param \Pcm\StructType\PcmCoordinates $corner1
     * @param \Pcm\StructType\PcmCoordinates $corner2
     * @param bool $includePlaces
     */
    public function __construct($placeName = null, $categoryId = null, $categoryName = null, \Pcm\StructType\PcmCoordinates $corner1 = null, \Pcm\StructType\PcmCoordinates $corner2 = null, $includePlaces = null)
    {
        $this
            ->setPlaceName($placeName)
            ->setCategoryId($categoryId)
            ->setCategoryName($categoryName)
            ->setCorner1($corner1)
            ->setCorner2($corner2)
            ->setIncludePlaces($includePlaces);
    }
    /**
     * Get PlaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaceName()
    {
        return isset($this->PlaceName) ? $this->PlaceName : null;
    }
    /**
     * Set PlaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $placeName
     * @return \Pcm\StructType\PcmGetCustomPlaceSetRequestBody
     */
    public function setPlaceName($placeName = null)
    {
        // validation for constraint: string
        if (!is_null($placeName) && !is_string($placeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeName)), __LINE__);
        }
        if (is_null($placeName) || (is_array($placeName) && empty($placeName))) {
            unset($this->PlaceName);
        } else {
            $this->PlaceName = $placeName;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $categoryId
     * @return \Pcm\StructType\PcmGetCustomPlaceSetRequestBody
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !is_numeric($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryId)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryName()
    {
        return isset($this->CategoryName) ? $this->CategoryName : null;
    }
    /**
     * Set CategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryName
     * @return \Pcm\StructType\PcmGetCustomPlaceSetRequestBody
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryName)), __LINE__);
        }
        if (is_null($categoryName) || (is_array($categoryName) && empty($categoryName))) {
            unset($this->CategoryName);
        } else {
            $this->CategoryName = $categoryName;
        }
        return $this;
    }
    /**
     * Get Corner1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCorner1()
    {
        return isset($this->Corner1) ? $this->Corner1 : null;
    }
    /**
     * Set Corner1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $corner1
     * @return \Pcm\StructType\PcmGetCustomPlaceSetRequestBody
     */
    public function setCorner1(\Pcm\StructType\PcmCoordinates $corner1 = null)
    {
        if (is_null($corner1) || (is_array($corner1) && empty($corner1))) {
            unset($this->Corner1);
        } else {
            $this->Corner1 = $corner1;
        }
        return $this;
    }
    /**
     * Get Corner2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCorner2()
    {
        return isset($this->Corner2) ? $this->Corner2 : null;
    }
    /**
     * Set Corner2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $corner2
     * @return \Pcm\StructType\PcmGetCustomPlaceSetRequestBody
     */
    public function setCorner2(\Pcm\StructType\PcmCoordinates $corner2 = null)
    {
        if (is_null($corner2) || (is_array($corner2) && empty($corner2))) {
            unset($this->Corner2);
        } else {
            $this->Corner2 = $corner2;
        }
        return $this;
    }
    /**
     * Get IncludePlaces value
     * @return bool|null
     */
    public function getIncludePlaces()
    {
        return $this->IncludePlaces;
    }
    /**
     * Set IncludePlaces value
     * @param bool $includePlaces
     * @return \Pcm\StructType\PcmGetCustomPlaceSetRequestBody
     */
    public function setIncludePlaces($includePlaces = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePlaces) && !is_bool($includePlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includePlaces)), __LINE__);
        }
        $this->IncludePlaces = $includePlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmGetCustomPlaceSetRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
