<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomPlaceRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomPlaceRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmCustomPlaceRequestBody extends AbstractStructBase
{
    /**
     * The PlaceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlaceName;
    /**
     * Constructor method for CustomPlaceRequestBody
     * @uses PcmCustomPlaceRequestBody::setPlaceName()
     * @param string $placeName
     */
    public function __construct($placeName = null)
    {
        $this
            ->setPlaceName($placeName);
    }
    /**
     * Get PlaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaceName()
    {
        return isset($this->PlaceName) ? $this->PlaceName : null;
    }
    /**
     * Set PlaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $placeName
     * @return \Pcm\StructType\PcmCustomPlaceRequestBody
     */
    public function setPlaceName($placeName = null)
    {
        // validation for constraint: string
        if (!is_null($placeName) && !is_string($placeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeName)), __LINE__);
        }
        if (is_null($placeName) || (is_array($placeName) && empty($placeName))) {
            unset($this->PlaceName);
        } else {
            $this->PlaceName = $placeName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmCustomPlaceRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
