<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @package Pcm
 * @subpackage Structs
 */
class PcmAddress extends AbstractStructBase
{
    /**
     * The StreetAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetAddress;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zip;
    /**
     * The County
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $County;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The SPLC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SPLC;
    /**
     * The CountryPostalFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CountryPostalFilter;
    /**
     * The AbbreviationFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AbbreviationFormat;
    /**
     * The StateName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateName;
    /**
     * The StateAbbreviation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateAbbreviation;
    /**
     * The CountryAbbreviation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryAbbreviation;
    /**
     * Constructor method for Address
     * @uses PcmAddress::setStreetAddress()
     * @uses PcmAddress::setCity()
     * @uses PcmAddress::setState()
     * @uses PcmAddress::setZip()
     * @uses PcmAddress::setCounty()
     * @uses PcmAddress::setCountry()
     * @uses PcmAddress::setSPLC()
     * @uses PcmAddress::setCountryPostalFilter()
     * @uses PcmAddress::setAbbreviationFormat()
     * @uses PcmAddress::setStateName()
     * @uses PcmAddress::setStateAbbreviation()
     * @uses PcmAddress::setCountryAbbreviation()
     * @param string $streetAddress
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $county
     * @param string $country
     * @param string $sPLC
     * @param string $countryPostalFilter
     * @param string $abbreviationFormat
     * @param string $stateName
     * @param string $stateAbbreviation
     * @param string $countryAbbreviation
     */
    public function __construct($streetAddress = null, $city = null, $state = null, $zip = null, $county = null, $country = null, $sPLC = null, $countryPostalFilter = null, $abbreviationFormat = null, $stateName = null, $stateAbbreviation = null, $countryAbbreviation = null)
    {
        $this
            ->setStreetAddress($streetAddress)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCounty($county)
            ->setCountry($country)
            ->setSPLC($sPLC)
            ->setCountryPostalFilter($countryPostalFilter)
            ->setAbbreviationFormat($abbreviationFormat)
            ->setStateName($stateName)
            ->setStateAbbreviation($stateAbbreviation)
            ->setCountryAbbreviation($countryAbbreviation);
    }
    /**
     * Get StreetAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetAddress()
    {
        return isset($this->StreetAddress) ? $this->StreetAddress : null;
    }
    /**
     * Set StreetAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetAddress
     * @return \Pcm\StructType\PcmAddress
     */
    public function setStreetAddress($streetAddress = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress) && !is_string($streetAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetAddress)), __LINE__);
        }
        if (is_null($streetAddress) || (is_array($streetAddress) && empty($streetAddress))) {
            unset($this->StreetAddress);
        } else {
            $this->StreetAddress = $streetAddress;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \Pcm\StructType\PcmAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \Pcm\StructType\PcmAddress
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Zip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZip()
    {
        return isset($this->Zip) ? $this->Zip : null;
    }
    /**
     * Set Zip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zip
     * @return \Pcm\StructType\PcmAddress
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        if (is_null($zip) || (is_array($zip) && empty($zip))) {
            unset($this->Zip);
        } else {
            $this->Zip = $zip;
        }
        return $this;
    }
    /**
     * Get County value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCounty()
    {
        return isset($this->County) ? $this->County : null;
    }
    /**
     * Set County value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $county
     * @return \Pcm\StructType\PcmAddress
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($county)), __LINE__);
        }
        if (is_null($county) || (is_array($county) && empty($county))) {
            unset($this->County);
        } else {
            $this->County = $county;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \Pcm\StructType\PcmAddress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get SPLC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSPLC()
    {
        return isset($this->SPLC) ? $this->SPLC : null;
    }
    /**
     * Set SPLC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sPLC
     * @return \Pcm\StructType\PcmAddress
     */
    public function setSPLC($sPLC = null)
    {
        // validation for constraint: string
        if (!is_null($sPLC) && !is_string($sPLC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPLC)), __LINE__);
        }
        if (is_null($sPLC) || (is_array($sPLC) && empty($sPLC))) {
            unset($this->SPLC);
        } else {
            $this->SPLC = $sPLC;
        }
        return $this;
    }
    /**
     * Get CountryPostalFilter value
     * @return string|null
     */
    public function getCountryPostalFilter()
    {
        return $this->CountryPostalFilter;
    }
    /**
     * Set CountryPostalFilter value
     * @uses \Pcm\EnumType\PcmPostCodeType::valueIsValid()
     * @uses \Pcm\EnumType\PcmPostCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryPostalFilter
     * @return \Pcm\StructType\PcmAddress
     */
    public function setCountryPostalFilter($countryPostalFilter = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPostCodeType::valueIsValid($countryPostalFilter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $countryPostalFilter, implode(', ', \Pcm\EnumType\PcmPostCodeType::getValidValues())), __LINE__);
        }
        $this->CountryPostalFilter = $countryPostalFilter;
        return $this;
    }
    /**
     * Get AbbreviationFormat value
     * @return string|null
     */
    public function getAbbreviationFormat()
    {
        return $this->AbbreviationFormat;
    }
    /**
     * Set AbbreviationFormat value
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid()
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abbreviationFormat
     * @return \Pcm\StructType\PcmAddress
     */
    public function setAbbreviationFormat($abbreviationFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid($abbreviationFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $abbreviationFormat, implode(', ', \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues())), __LINE__);
        }
        $this->AbbreviationFormat = $abbreviationFormat;
        return $this;
    }
    /**
     * Get StateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateName()
    {
        return isset($this->StateName) ? $this->StateName : null;
    }
    /**
     * Set StateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateName
     * @return \Pcm\StructType\PcmAddress
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateName)), __LINE__);
        }
        if (is_null($stateName) || (is_array($stateName) && empty($stateName))) {
            unset($this->StateName);
        } else {
            $this->StateName = $stateName;
        }
        return $this;
    }
    /**
     * Get StateAbbreviation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateAbbreviation()
    {
        return isset($this->StateAbbreviation) ? $this->StateAbbreviation : null;
    }
    /**
     * Set StateAbbreviation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateAbbreviation
     * @return \Pcm\StructType\PcmAddress
     */
    public function setStateAbbreviation($stateAbbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($stateAbbreviation) && !is_string($stateAbbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateAbbreviation)), __LINE__);
        }
        if (is_null($stateAbbreviation) || (is_array($stateAbbreviation) && empty($stateAbbreviation))) {
            unset($this->StateAbbreviation);
        } else {
            $this->StateAbbreviation = $stateAbbreviation;
        }
        return $this;
    }
    /**
     * Get CountryAbbreviation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryAbbreviation()
    {
        return isset($this->CountryAbbreviation) ? $this->CountryAbbreviation : null;
    }
    /**
     * Set CountryAbbreviation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryAbbreviation
     * @return \Pcm\StructType\PcmAddress
     */
    public function setCountryAbbreviation($countryAbbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($countryAbbreviation) && !is_string($countryAbbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryAbbreviation)), __LINE__);
        }
        if (is_null($countryAbbreviation) || (is_array($countryAbbreviation) && empty($countryAbbreviation))) {
            unset($this->CountryAbbreviation);
        } else {
            $this->CountryAbbreviation = $countryAbbreviation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
