<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AFSet StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AFSet
 * @package Pcm
 * @subpackage Structs
 */
class PcmAFSet extends AbstractStructBase
{
    /**
     * The DataVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataVersion;
    /**
     * The Links
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfAFLink
     */
    public $Links;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SetID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SetID;
    /**
     * The Tag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tag;
    /**
     * Constructor method for AFSet
     * @uses PcmAFSet::setDataVersion()
     * @uses PcmAFSet::setLinks()
     * @uses PcmAFSet::setName()
     * @uses PcmAFSet::setSetID()
     * @uses PcmAFSet::setTag()
     * @param string $dataVersion
     * @param \Pcm\ArrayType\PcmArrayOfAFLink $links
     * @param string $name
     * @param int $setID
     * @param string $tag
     */
    public function __construct($dataVersion = null, \Pcm\ArrayType\PcmArrayOfAFLink $links = null, $name = null, $setID = null, $tag = null)
    {
        $this
            ->setDataVersion($dataVersion)
            ->setLinks($links)
            ->setName($name)
            ->setSetID($setID)
            ->setTag($tag);
    }
    /**
     * Get DataVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataVersion()
    {
        return isset($this->DataVersion) ? $this->DataVersion : null;
    }
    /**
     * Set DataVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataVersion
     * @return \Pcm\StructType\PcmAFSet
     */
    public function setDataVersion($dataVersion = null)
    {
        // validation for constraint: string
        if (!is_null($dataVersion) && !is_string($dataVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataVersion)), __LINE__);
        }
        if (is_null($dataVersion) || (is_array($dataVersion) && empty($dataVersion))) {
            unset($this->DataVersion);
        } else {
            $this->DataVersion = $dataVersion;
        }
        return $this;
    }
    /**
     * Get Links value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfAFLink|null
     */
    public function getLinks()
    {
        return isset($this->Links) ? $this->Links : null;
    }
    /**
     * Set Links value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfAFLink $links
     * @return \Pcm\StructType\PcmAFSet
     */
    public function setLinks(\Pcm\ArrayType\PcmArrayOfAFLink $links = null)
    {
        if (is_null($links) || (is_array($links) && empty($links))) {
            unset($this->Links);
        } else {
            $this->Links = $links;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \Pcm\StructType\PcmAFSet
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SetID value
     * @return int|null
     */
    public function getSetID()
    {
        return $this->SetID;
    }
    /**
     * Set SetID value
     * @param int $setID
     * @return \Pcm\StructType\PcmAFSet
     */
    public function setSetID($setID = null)
    {
        // validation for constraint: int
        if (!is_null($setID) && !is_numeric($setID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($setID)), __LINE__);
        }
        $this->SetID = $setID;
        return $this;
    }
    /**
     * Get Tag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTag()
    {
        return isset($this->Tag) ? $this->Tag : null;
    }
    /**
     * Set Tag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tag
     * @return \Pcm\StructType\PcmAFSet
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tag)), __LINE__);
        }
        if (is_null($tag) || (is_array($tag) && empty($tag))) {
            unset($this->Tag);
        } else {
            $this->Tag = $tag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAFSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
