<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AFExtraInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AFExtraInfo
 * @package Pcm
 * @subpackage Structs
 */
class PcmAFExtraInfo extends AbstractStructBase
{
    /**
     * The IsBorder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsBorder;
    /**
     * The MaxAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxAddress;
    /**
     * The MinAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinAddress;
    /**
     * The RoadClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoadClass;
    /**
     * The RouteNum1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RouteNum1;
    /**
     * The RouteNum2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RouteNum2;
    /**
     * The RouteNum3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RouteNum3;
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * Constructor method for AFExtraInfo
     * @uses PcmAFExtraInfo::setIsBorder()
     * @uses PcmAFExtraInfo::setMaxAddress()
     * @uses PcmAFExtraInfo::setMinAddress()
     * @uses PcmAFExtraInfo::setRoadClass()
     * @uses PcmAFExtraInfo::setRouteNum1()
     * @uses PcmAFExtraInfo::setRouteNum2()
     * @uses PcmAFExtraInfo::setRouteNum3()
     * @uses PcmAFExtraInfo::setStreetName()
     * @param bool $isBorder
     * @param int $maxAddress
     * @param int $minAddress
     * @param string $roadClass
     * @param int $routeNum1
     * @param int $routeNum2
     * @param int $routeNum3
     * @param string $streetName
     */
    public function __construct($isBorder = null, $maxAddress = null, $minAddress = null, $roadClass = null, $routeNum1 = null, $routeNum2 = null, $routeNum3 = null, $streetName = null)
    {
        $this
            ->setIsBorder($isBorder)
            ->setMaxAddress($maxAddress)
            ->setMinAddress($minAddress)
            ->setRoadClass($roadClass)
            ->setRouteNum1($routeNum1)
            ->setRouteNum2($routeNum2)
            ->setRouteNum3($routeNum3)
            ->setStreetName($streetName);
    }
    /**
     * Get IsBorder value
     * @return bool|null
     */
    public function getIsBorder()
    {
        return $this->IsBorder;
    }
    /**
     * Set IsBorder value
     * @param bool $isBorder
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public function setIsBorder($isBorder = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBorder) && !is_bool($isBorder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBorder)), __LINE__);
        }
        $this->IsBorder = $isBorder;
        return $this;
    }
    /**
     * Get MaxAddress value
     * @return int|null
     */
    public function getMaxAddress()
    {
        return $this->MaxAddress;
    }
    /**
     * Set MaxAddress value
     * @param int $maxAddress
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public function setMaxAddress($maxAddress = null)
    {
        // validation for constraint: int
        if (!is_null($maxAddress) && !is_numeric($maxAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAddress)), __LINE__);
        }
        $this->MaxAddress = $maxAddress;
        return $this;
    }
    /**
     * Get MinAddress value
     * @return int|null
     */
    public function getMinAddress()
    {
        return $this->MinAddress;
    }
    /**
     * Set MinAddress value
     * @param int $minAddress
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public function setMinAddress($minAddress = null)
    {
        // validation for constraint: int
        if (!is_null($minAddress) && !is_numeric($minAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minAddress)), __LINE__);
        }
        $this->MinAddress = $minAddress;
        return $this;
    }
    /**
     * Get RoadClass value
     * @return string|null
     */
    public function getRoadClass()
    {
        return $this->RoadClass;
    }
    /**
     * Set RoadClass value
     * @param string $roadClass
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public function setRoadClass($roadClass = null)
    {
        // validation for constraint: string
        if (!is_null($roadClass) && !is_string($roadClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadClass)), __LINE__);
        }
        $this->RoadClass = $roadClass;
        return $this;
    }
    /**
     * Get RouteNum1 value
     * @return int|null
     */
    public function getRouteNum1()
    {
        return $this->RouteNum1;
    }
    /**
     * Set RouteNum1 value
     * @param int $routeNum1
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public function setRouteNum1($routeNum1 = null)
    {
        // validation for constraint: int
        if (!is_null($routeNum1) && !is_numeric($routeNum1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($routeNum1)), __LINE__);
        }
        $this->RouteNum1 = $routeNum1;
        return $this;
    }
    /**
     * Get RouteNum2 value
     * @return int|null
     */
    public function getRouteNum2()
    {
        return $this->RouteNum2;
    }
    /**
     * Set RouteNum2 value
     * @param int $routeNum2
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public function setRouteNum2($routeNum2 = null)
    {
        // validation for constraint: int
        if (!is_null($routeNum2) && !is_numeric($routeNum2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($routeNum2)), __LINE__);
        }
        $this->RouteNum2 = $routeNum2;
        return $this;
    }
    /**
     * Get RouteNum3 value
     * @return int|null
     */
    public function getRouteNum3()
    {
        return $this->RouteNum3;
    }
    /**
     * Set RouteNum3 value
     * @param int $routeNum3
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public function setRouteNum3($routeNum3 = null)
    {
        // validation for constraint: int
        if (!is_null($routeNum3) && !is_numeric($routeNum3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($routeNum3)), __LINE__);
        }
        $this->RouteNum3 = $routeNum3;
        return $this;
    }
    /**
     * Get StreetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetName()
    {
        return isset($this->StreetName) ? $this->StreetName : null;
    }
    /**
     * Set StreetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetName
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        if (is_null($streetName) || (is_array($streetName) && empty($streetName))) {
            unset($this->StreetName);
        } else {
            $this->StreetName = $streetName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAFExtraInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
