<?php

namespace Pcm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package Pcm
 * @subpackage Services
 */
class PcmGet extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pcm\StructType\PcmAuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\Pcm\StructType\PcmAuthHeader $authHeader, $nameSpace = 'http://pcmiler.alk.com/APIs/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetAvoidFavor
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetAvoidFavor $parameters
     * @return \Pcm\StructType\PcmGetAvoidFavorResponse|bool
     */
    public function GetAvoidFavor(\Pcm\StructType\PcmGetAvoidFavor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAvoidFavor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomPlaces
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetCustomPlaces $parameters
     * @return \Pcm\StructType\PcmGetCustomPlacesResponse|bool
     */
    public function GetCustomPlaces(\Pcm\StructType\PcmGetCustomPlaces $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomPlaces($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRoadSpeeds
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetRoadSpeeds $parameters
     * @return \Pcm\StructType\PcmGetRoadSpeedsResponse|bool
     */
    public function GetRoadSpeeds(\Pcm\StructType\PcmGetRoadSpeeds $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRoadSpeeds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetETAOutOfRouteReport
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetETAOutOfRouteReport $parameters
     * @return \Pcm\StructType\PcmGetETAOutOfRouteReportResponse|bool
     */
    public function GetETAOutOfRouteReport(\Pcm\StructType\PcmGetETAOutOfRouteReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetETAOutOfRouteReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReports
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetReports $parameters
     * @return \Pcm\StructType\PcmGetReportsResponse|bool
     */
    public function GetReports(\Pcm\StructType\PcmGetReports $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReports($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReportsLegacy
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetReportsLegacy $parameters
     * @return \Pcm\StructType\PcmGetReportsLegacyResponse|bool
     */
    public function GetReportsLegacy(\Pcm\StructType\PcmGetReportsLegacy $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReportsLegacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPoisAlongRoute
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetPoisAlongRoute $parameters
     * @return \Pcm\StructType\PcmGetPoisAlongRouteResponse|bool
     */
    public function GetPoisAlongRoute(\Pcm\StructType\PcmGetPoisAlongRoute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPoisAlongRoute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvoidFavorSets
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetAvoidFavorSets $parameters
     * @return \Pcm\StructType\PcmGetAvoidFavorSetsResponse|bool
     */
    public function GetAvoidFavorSets(\Pcm\StructType\PcmGetAvoidFavorSets $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAvoidFavorSets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWeatherAlerts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetWeatherAlerts $parameters
     * @return \Pcm\StructType\PcmGetWeatherAlertsResponse|bool
     */
    public function GetWeatherAlerts(\Pcm\StructType\PcmGetWeatherAlerts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWeatherAlerts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRouteMatrix
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://pcmiler.alk.com/APIs/v1.0
     * - SOAPHeaderTypes: \Pcm\StructType\PcmAuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pcm\StructType\PcmGetRouteMatrix $parameters
     * @return \Pcm\StructType\PcmGetRouteMatrixResponse|bool
     */
    public function GetRouteMatrix(\Pcm\StructType\PcmGetRouteMatrix $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRouteMatrix($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pcm\StructType\PcmGetAvoidFavorResponse|\Pcm\StructType\PcmGetAvoidFavorSetsResponse|\Pcm\StructType\PcmGetCustomPlacesResponse|\Pcm\StructType\PcmGetETAOutOfRouteReportResponse|\Pcm\StructType\PcmGetPoisAlongRouteResponse|\Pcm\StructType\PcmGetReportsLegacyResponse|\Pcm\StructType\PcmGetReportsResponse|\Pcm\StructType\PcmGetRoadSpeedsResponse|\Pcm\StructType\PcmGetRouteMatrixResponse|\Pcm\StructType\PcmGetWeatherAlertsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
