<?php

namespace Pcm\EnumType;

/**
 * This class stands for WeatherAlertSeverity EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WeatherAlertSeverity
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmWeatherAlertSeverity
{
    /**
     * Constant for value 'Extreme'
     * @return string 'Extreme'
     */
    const VALUE_EXTREME = 'Extreme';
    /**
     * Constant for value 'Severe'
     * @return string 'Severe'
     */
    const VALUE_SEVERE = 'Severe';
    /**
     * Constant for value 'Moderate'
     * @return string 'Moderate'
     */
    const VALUE_MODERATE = 'Moderate';
    /**
     * Constant for value 'Minor'
     * @return string 'Minor'
     */
    const VALUE_MINOR = 'Minor';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXTREME
     * @uses self::VALUE_SEVERE
     * @uses self::VALUE_MODERATE
     * @uses self::VALUE_MINOR
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXTREME,
            self::VALUE_SEVERE,
            self::VALUE_MODERATE,
            self::VALUE_MINOR,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
