<?php

namespace Pcm\EnumType;

/**
 * This class stands for GeofenceShape EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GeofenceShape
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmGeofenceShape
{
    /**
     * Constant for value 'Circle'
     * @return string 'Circle'
     */
    const VALUE_CIRCLE = 'Circle';
    /**
     * Constant for value 'Polygon'
     * @return string 'Polygon'
     */
    const VALUE_POLYGON = 'Polygon';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CIRCLE
     * @uses self::VALUE_POLYGON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CIRCLE,
            self::VALUE_POLYGON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
