<?php

namespace Pcm\EnumType;

/**
 * This class stands for DistanceUnits EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DistanceUnits
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmDistanceUnits
{
    /**
     * Constant for value 'Miles'
     * @return string 'Miles'
     */
    const VALUE_MILES = 'Miles';
    /**
     * Constant for value 'Kilometers'
     * @return string 'Kilometers'
     */
    const VALUE_KILOMETERS = 'Kilometers';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MILES
     * @uses self::VALUE_KILOMETERS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MILES,
            self::VALUE_KILOMETERS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
