<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGeocodeLocation ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfGeocodeLocation
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfGeocodeLocation extends AbstractStructArrayBase
{
    /**
     * The GeocodeLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmGeocodeLocation[]
     */
    public $GeocodeLocation;
    /**
     * Constructor method for ArrayOfGeocodeLocation
     * @uses PcmArrayOfGeocodeLocation::setGeocodeLocation()
     * @param \Pcm\StructType\PcmGeocodeLocation[] $geocodeLocation
     */
    public function __construct(array $geocodeLocation = array())
    {
        $this
            ->setGeocodeLocation($geocodeLocation);
    }
    /**
     * Get GeocodeLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmGeocodeLocation[]|null
     */
    public function getGeocodeLocation()
    {
        return isset($this->GeocodeLocation) ? $this->GeocodeLocation : null;
    }
    /**
     * Set GeocodeLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmGeocodeLocation[] $geocodeLocation
     * @return \Pcm\ArrayType\PcmArrayOfGeocodeLocation
     */
    public function setGeocodeLocation(array $geocodeLocation = array())
    {
        foreach ($geocodeLocation as $arrayOfGeocodeLocationGeocodeLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfGeocodeLocationGeocodeLocationItem instanceof \Pcm\StructType\PcmGeocodeLocation) {
                throw new \InvalidArgumentException(sprintf('The GeocodeLocation property can only contain items of \Pcm\StructType\PcmGeocodeLocation, "%s" given', is_object($arrayOfGeocodeLocationGeocodeLocationItem) ? get_class($arrayOfGeocodeLocationGeocodeLocationItem) : gettype($arrayOfGeocodeLocationGeocodeLocationItem)), __LINE__);
            }
        }
        if (is_null($geocodeLocation) || (is_array($geocodeLocation) && empty($geocodeLocation))) {
            unset($this->GeocodeLocation);
        } else {
            $this->GeocodeLocation = $geocodeLocation;
        }
        return $this;
    }
    /**
     * Add item to GeocodeLocation value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmGeocodeLocation $item
     * @return \Pcm\ArrayType\PcmArrayOfGeocodeLocation
     */
    public function addToGeocodeLocation(\Pcm\StructType\PcmGeocodeLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmGeocodeLocation) {
            throw new \InvalidArgumentException(sprintf('The GeocodeLocation property can only contain items of \Pcm\StructType\PcmGeocodeLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GeocodeLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmGeocodeLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmGeocodeLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmGeocodeLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmGeocodeLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmGeocodeLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GeocodeLocation
     */
    public function getAttributeName()
    {
        return 'GeocodeLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfGeocodeLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
