<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAFSet ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAFSet
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfAFSet extends AbstractStructArrayBase
{
    /**
     * The AFSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmAFSet[]
     */
    public $AFSet;
    /**
     * Constructor method for ArrayOfAFSet
     * @uses PcmArrayOfAFSet::setAFSet()
     * @param \Pcm\StructType\PcmAFSet[] $aFSet
     */
    public function __construct(array $aFSet = array())
    {
        $this
            ->setAFSet($aFSet);
    }
    /**
     * Get AFSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmAFSet[]|null
     */
    public function getAFSet()
    {
        return isset($this->AFSet) ? $this->AFSet : null;
    }
    /**
     * Set AFSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmAFSet[] $aFSet
     * @return \Pcm\ArrayType\PcmArrayOfAFSet
     */
    public function setAFSet(array $aFSet = array())
    {
        foreach ($aFSet as $arrayOfAFSetAFSetItem) {
            // validation for constraint: itemType
            if (!$arrayOfAFSetAFSetItem instanceof \Pcm\StructType\PcmAFSet) {
                throw new \InvalidArgumentException(sprintf('The AFSet property can only contain items of \Pcm\StructType\PcmAFSet, "%s" given', is_object($arrayOfAFSetAFSetItem) ? get_class($arrayOfAFSetAFSetItem) : gettype($arrayOfAFSetAFSetItem)), __LINE__);
            }
        }
        if (is_null($aFSet) || (is_array($aFSet) && empty($aFSet))) {
            unset($this->AFSet);
        } else {
            $this->AFSet = $aFSet;
        }
        return $this;
    }
    /**
     * Add item to AFSet value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmAFSet $item
     * @return \Pcm\ArrayType\PcmArrayOfAFSet
     */
    public function addToAFSet(\Pcm\StructType\PcmAFSet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmAFSet) {
            throw new \InvalidArgumentException(sprintf('The AFSet property can only contain items of \Pcm\StructType\PcmAFSet, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AFSet[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmAFSet|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmAFSet|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmAFSet|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmAFSet|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmAFSet|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AFSet
     */
    public function getAttributeName()
    {
        return 'AFSet';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfAFSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
