<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TollDetailReport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TollDetailReport
 * @package Pcm
 * @subpackage Structs
 */
class PcmTollDetailReport extends PcmReport
{
    /**
     * The SegmentLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfTollDetailReportSegmentLine
     */
    public $SegmentLines;
    /**
     * The SummaryLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfTollDetailReportSummaryLine
     */
    public $SummaryLines;
    /**
     * The TollCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TollCurrency;
    /**
     * Constructor method for TollDetailReport
     * @uses PcmTollDetailReport::setSegmentLines()
     * @uses PcmTollDetailReport::setSummaryLines()
     * @uses PcmTollDetailReport::setTollCurrency()
     * @param \Pcm\ArrayType\PcmArrayOfTollDetailReportSegmentLine $segmentLines
     * @param \Pcm\ArrayType\PcmArrayOfTollDetailReportSummaryLine $summaryLines
     * @param string $tollCurrency
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfTollDetailReportSegmentLine $segmentLines = null, \Pcm\ArrayType\PcmArrayOfTollDetailReportSummaryLine $summaryLines = null, $tollCurrency = null)
    {
        $this
            ->setSegmentLines($segmentLines)
            ->setSummaryLines($summaryLines)
            ->setTollCurrency($tollCurrency);
    }
    /**
     * Get SegmentLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfTollDetailReportSegmentLine|null
     */
    public function getSegmentLines()
    {
        return isset($this->SegmentLines) ? $this->SegmentLines : null;
    }
    /**
     * Set SegmentLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfTollDetailReportSegmentLine $segmentLines
     * @return \Pcm\StructType\PcmTollDetailReport
     */
    public function setSegmentLines(\Pcm\ArrayType\PcmArrayOfTollDetailReportSegmentLine $segmentLines = null)
    {
        if (is_null($segmentLines) || (is_array($segmentLines) && empty($segmentLines))) {
            unset($this->SegmentLines);
        } else {
            $this->SegmentLines = $segmentLines;
        }
        return $this;
    }
    /**
     * Get SummaryLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfTollDetailReportSummaryLine|null
     */
    public function getSummaryLines()
    {
        return isset($this->SummaryLines) ? $this->SummaryLines : null;
    }
    /**
     * Set SummaryLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfTollDetailReportSummaryLine $summaryLines
     * @return \Pcm\StructType\PcmTollDetailReport
     */
    public function setSummaryLines(\Pcm\ArrayType\PcmArrayOfTollDetailReportSummaryLine $summaryLines = null)
    {
        if (is_null($summaryLines) || (is_array($summaryLines) && empty($summaryLines))) {
            unset($this->SummaryLines);
        } else {
            $this->SummaryLines = $summaryLines;
        }
        return $this;
    }
    /**
     * Get TollCurrency value
     * @return string|null
     */
    public function getTollCurrency()
    {
        return $this->TollCurrency;
    }
    /**
     * Set TollCurrency value
     * @uses \Pcm\EnumType\PcmCurrency::valueIsValid()
     * @uses \Pcm\EnumType\PcmCurrency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tollCurrency
     * @return \Pcm\StructType\PcmTollDetailReport
     */
    public function setTollCurrency($tollCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmCurrency::valueIsValid($tollCurrency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tollCurrency, implode(', ', \Pcm\EnumType\PcmCurrency::getValidValues())), __LINE__);
        }
        $this->TollCurrency = $tollCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmTollDetailReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
