<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequestHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceRequestHeader
 * @package Pcm
 * @subpackage Structs
 */
class PcmServiceRequestHeader extends PcmRequestHeader
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $APIKey;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Account;
    /**
     * The AccountId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccountId;
    /**
     * The FeatureLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FeatureLevel;
    /**
     * The IsAdmin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAdmin;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UserId;
    /**
     * The IsMapSureEnterprise
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMapSureEnterprise;
    /**
     * The EncryptedOwnerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EncryptedOwnerId;
    /**
     * Constructor method for ServiceRequestHeader
     * @uses PcmServiceRequestHeader::setAPIKey()
     * @uses PcmServiceRequestHeader::setAccount()
     * @uses PcmServiceRequestHeader::setAccountId()
     * @uses PcmServiceRequestHeader::setFeatureLevel()
     * @uses PcmServiceRequestHeader::setIsAdmin()
     * @uses PcmServiceRequestHeader::setUserId()
     * @uses PcmServiceRequestHeader::setIsMapSureEnterprise()
     * @uses PcmServiceRequestHeader::setEncryptedOwnerId()
     * @param string $aPIKey
     * @param string $account
     * @param int $accountId
     * @param int $featureLevel
     * @param bool $isAdmin
     * @param int $userId
     * @param bool $isMapSureEnterprise
     * @param string $encryptedOwnerId
     */
    public function __construct($aPIKey = null, $account = null, $accountId = null, $featureLevel = null, $isAdmin = null, $userId = null, $isMapSureEnterprise = null, $encryptedOwnerId = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setAccount($account)
            ->setAccountId($accountId)
            ->setFeatureLevel($featureLevel)
            ->setIsAdmin($isAdmin)
            ->setUserId($userId)
            ->setIsMapSureEnterprise($isMapSureEnterprise)
            ->setEncryptedOwnerId($encryptedOwnerId);
    }
    /**
     * Get APIKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAPIKey()
    {
        return isset($this->APIKey) ? $this->APIKey : null;
    }
    /**
     * Set APIKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aPIKey
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        if (is_null($aPIKey) || (is_array($aPIKey) && empty($aPIKey))) {
            unset($this->APIKey);
        } else {
            $this->APIKey = $aPIKey;
        }
        return $this;
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $account
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($account)), __LINE__);
        }
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accountId
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !is_numeric($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountId)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get FeatureLevel value
     * @return int|null
     */
    public function getFeatureLevel()
    {
        return $this->FeatureLevel;
    }
    /**
     * Set FeatureLevel value
     * @param int $featureLevel
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public function setFeatureLevel($featureLevel = null)
    {
        // validation for constraint: int
        if (!is_null($featureLevel) && !is_numeric($featureLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($featureLevel)), __LINE__);
        }
        $this->FeatureLevel = $featureLevel;
        return $this;
    }
    /**
     * Get IsAdmin value
     * @return bool|null
     */
    public function getIsAdmin()
    {
        return $this->IsAdmin;
    }
    /**
     * Set IsAdmin value
     * @param bool $isAdmin
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public function setIsAdmin($isAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdmin) && !is_bool($isAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAdmin)), __LINE__);
        }
        $this->IsAdmin = $isAdmin;
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userId
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !is_numeric($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get IsMapSureEnterprise value
     * @return bool|null
     */
    public function getIsMapSureEnterprise()
    {
        return $this->IsMapSureEnterprise;
    }
    /**
     * Set IsMapSureEnterprise value
     * @param bool $isMapSureEnterprise
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public function setIsMapSureEnterprise($isMapSureEnterprise = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMapSureEnterprise) && !is_bool($isMapSureEnterprise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMapSureEnterprise)), __LINE__);
        }
        $this->IsMapSureEnterprise = $isMapSureEnterprise;
        return $this;
    }
    /**
     * Get EncryptedOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEncryptedOwnerId()
    {
        return isset($this->EncryptedOwnerId) ? $this->EncryptedOwnerId : null;
    }
    /**
     * Set EncryptedOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $encryptedOwnerId
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public function setEncryptedOwnerId($encryptedOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($encryptedOwnerId) && !is_string($encryptedOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encryptedOwnerId)), __LINE__);
        }
        if (is_null($encryptedOwnerId) || (is_array($encryptedOwnerId) && empty($encryptedOwnerId))) {
            unset($this->EncryptedOwnerId);
        } else {
            $this->EncryptedOwnerId = $encryptedOwnerId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmServiceRequestHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
