<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteMatrixResponseBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteMatrixResponseBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmRouteMatrixResponseBody extends AbstractStructBase
{
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation
     */
    public $Destinations;
    /**
     * The MatrixInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfArrayOfRouteMatrixInfo
     */
    public $MatrixInfo;
    /**
     * Constructor method for RouteMatrixResponseBody
     * @uses PcmRouteMatrixResponseBody::setOrigins()
     * @uses PcmRouteMatrixResponseBody::setDestinations()
     * @uses PcmRouteMatrixResponseBody::setMatrixInfo()
     * @param \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation $origins
     * @param \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation $destinations
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfRouteMatrixInfo $matrixInfo
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation $origins = null, \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation $destinations = null, \Pcm\ArrayType\PcmArrayOfArrayOfRouteMatrixInfo $matrixInfo = null)
    {
        $this
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setMatrixInfo($matrixInfo);
    }
    /**
     * Get Origins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation|null
     */
    public function getOrigins()
    {
        return isset($this->Origins) ? $this->Origins : null;
    }
    /**
     * Set Origins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation $origins
     * @return \Pcm\StructType\PcmRouteMatrixResponseBody
     */
    public function setOrigins(\Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation $origins = null)
    {
        if (is_null($origins) || (is_array($origins) && empty($origins))) {
            unset($this->Origins);
        } else {
            $this->Origins = $origins;
        }
        return $this;
    }
    /**
     * Get Destinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation|null
     */
    public function getDestinations()
    {
        return isset($this->Destinations) ? $this->Destinations : null;
    }
    /**
     * Set Destinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation $destinations
     * @return \Pcm\StructType\PcmRouteMatrixResponseBody
     */
    public function setDestinations(\Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation $destinations = null)
    {
        if (is_null($destinations) || (is_array($destinations) && empty($destinations))) {
            unset($this->Destinations);
        } else {
            $this->Destinations = $destinations;
        }
        return $this;
    }
    /**
     * Get MatrixInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfRouteMatrixInfo|null
     */
    public function getMatrixInfo()
    {
        return isset($this->MatrixInfo) ? $this->MatrixInfo : null;
    }
    /**
     * Set MatrixInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfRouteMatrixInfo $matrixInfo
     * @return \Pcm\StructType\PcmRouteMatrixResponseBody
     */
    public function setMatrixInfo(\Pcm\ArrayType\PcmArrayOfArrayOfRouteMatrixInfo $matrixInfo = null)
    {
        if (is_null($matrixInfo) || (is_array($matrixInfo) && empty($matrixInfo))) {
            unset($this->MatrixInfo);
        } else {
            $this->MatrixInfo = $matrixInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRouteMatrixResponseBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
