<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadSpeedBase StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoadSpeedBase
 * @package Pcm
 * @subpackage Structs
 */
class PcmRoadSpeedBase extends AbstractStructBase
{
    /**
     * The RoadCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoadCategory;
    /**
     * The Speed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Speed;
    /**
     * Constructor method for RoadSpeedBase
     * @uses PcmRoadSpeedBase::setRoadCategory()
     * @uses PcmRoadSpeedBase::setSpeed()
     * @param string $roadCategory
     * @param int $speed
     */
    public function __construct($roadCategory = null, $speed = null)
    {
        $this
            ->setRoadCategory($roadCategory)
            ->setSpeed($speed);
    }
    /**
     * Get RoadCategory value
     * @return string|null
     */
    public function getRoadCategory()
    {
        return $this->RoadCategory;
    }
    /**
     * Set RoadCategory value
     * @uses \Pcm\EnumType\PcmRoadType::valueIsValid()
     * @uses \Pcm\EnumType\PcmRoadType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roadCategory
     * @return \Pcm\StructType\PcmRoadSpeedBase
     */
    public function setRoadCategory($roadCategory = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmRoadType::valueIsValid($roadCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roadCategory, implode(', ', \Pcm\EnumType\PcmRoadType::getValidValues())), __LINE__);
        }
        $this->RoadCategory = $roadCategory;
        return $this;
    }
    /**
     * Get Speed value
     * @return int|null
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \Pcm\StructType\PcmRoadSpeedBase
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !is_numeric($speed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRoadSpeedBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
