<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReverseGeocodeRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReverseGeocodeRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmReverseGeocodeRequestBody extends AbstractStructBase
{
    /**
     * The Coords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfReverseGeoCoord
     */
    public $Coords;
    /**
     * The IncludePostedSpeedLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePostedSpeedLimit;
    /**
     * The MatchNamedRoadsOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MatchNamedRoadsOnly;
    /**
     * The MaxCleanupMiles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxCleanupMiles;
    /**
     * The CountryAbbrevType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CountryAbbrevType;
    /**
     * Constructor method for ReverseGeocodeRequestBody
     * @uses PcmReverseGeocodeRequestBody::setCoords()
     * @uses PcmReverseGeocodeRequestBody::setIncludePostedSpeedLimit()
     * @uses PcmReverseGeocodeRequestBody::setMatchNamedRoadsOnly()
     * @uses PcmReverseGeocodeRequestBody::setMaxCleanupMiles()
     * @uses PcmReverseGeocodeRequestBody::setCountryAbbrevType()
     * @param \Pcm\ArrayType\PcmArrayOfReverseGeoCoord $coords
     * @param bool $includePostedSpeedLimit
     * @param bool $matchNamedRoadsOnly
     * @param float $maxCleanupMiles
     * @param string $countryAbbrevType
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfReverseGeoCoord $coords = null, $includePostedSpeedLimit = null, $matchNamedRoadsOnly = null, $maxCleanupMiles = null, $countryAbbrevType = null)
    {
        $this
            ->setCoords($coords)
            ->setIncludePostedSpeedLimit($includePostedSpeedLimit)
            ->setMatchNamedRoadsOnly($matchNamedRoadsOnly)
            ->setMaxCleanupMiles($maxCleanupMiles)
            ->setCountryAbbrevType($countryAbbrevType);
    }
    /**
     * Get Coords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfReverseGeoCoord|null
     */
    public function getCoords()
    {
        return isset($this->Coords) ? $this->Coords : null;
    }
    /**
     * Set Coords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfReverseGeoCoord $coords
     * @return \Pcm\StructType\PcmReverseGeocodeRequestBody
     */
    public function setCoords(\Pcm\ArrayType\PcmArrayOfReverseGeoCoord $coords = null)
    {
        if (is_null($coords) || (is_array($coords) && empty($coords))) {
            unset($this->Coords);
        } else {
            $this->Coords = $coords;
        }
        return $this;
    }
    /**
     * Get IncludePostedSpeedLimit value
     * @return bool|null
     */
    public function getIncludePostedSpeedLimit()
    {
        return $this->IncludePostedSpeedLimit;
    }
    /**
     * Set IncludePostedSpeedLimit value
     * @param bool $includePostedSpeedLimit
     * @return \Pcm\StructType\PcmReverseGeocodeRequestBody
     */
    public function setIncludePostedSpeedLimit($includePostedSpeedLimit = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePostedSpeedLimit) && !is_bool($includePostedSpeedLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includePostedSpeedLimit)), __LINE__);
        }
        $this->IncludePostedSpeedLimit = $includePostedSpeedLimit;
        return $this;
    }
    /**
     * Get MatchNamedRoadsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMatchNamedRoadsOnly()
    {
        return isset($this->MatchNamedRoadsOnly) ? $this->MatchNamedRoadsOnly : null;
    }
    /**
     * Set MatchNamedRoadsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $matchNamedRoadsOnly
     * @return \Pcm\StructType\PcmReverseGeocodeRequestBody
     */
    public function setMatchNamedRoadsOnly($matchNamedRoadsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($matchNamedRoadsOnly) && !is_bool($matchNamedRoadsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($matchNamedRoadsOnly)), __LINE__);
        }
        if (is_null($matchNamedRoadsOnly) || (is_array($matchNamedRoadsOnly) && empty($matchNamedRoadsOnly))) {
            unset($this->MatchNamedRoadsOnly);
        } else {
            $this->MatchNamedRoadsOnly = $matchNamedRoadsOnly;
        }
        return $this;
    }
    /**
     * Get MaxCleanupMiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxCleanupMiles()
    {
        return isset($this->MaxCleanupMiles) ? $this->MaxCleanupMiles : null;
    }
    /**
     * Set MaxCleanupMiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxCleanupMiles
     * @return \Pcm\StructType\PcmReverseGeocodeRequestBody
     */
    public function setMaxCleanupMiles($maxCleanupMiles = null)
    {
        if (is_null($maxCleanupMiles) || (is_array($maxCleanupMiles) && empty($maxCleanupMiles))) {
            unset($this->MaxCleanupMiles);
        } else {
            $this->MaxCleanupMiles = $maxCleanupMiles;
        }
        return $this;
    }
    /**
     * Get CountryAbbrevType value
     * @return string|null
     */
    public function getCountryAbbrevType()
    {
        return $this->CountryAbbrevType;
    }
    /**
     * Set CountryAbbrevType value
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid()
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryAbbrevType
     * @return \Pcm\StructType\PcmReverseGeocodeRequestBody
     */
    public function setCountryAbbrevType($countryAbbrevType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid($countryAbbrevType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $countryAbbrevType, implode(', ', \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues())), __LINE__);
        }
        $this->CountryAbbrevType = $countryAbbrevType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmReverseGeocodeRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
