<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Report StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Report
 * @package Pcm
 * @subpackage Structs
 */
class PcmReport extends AbstractStructBase
{
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * Constructor method for Report
     * @uses PcmReport::setRouteID()
     * @param string $routeID
     */
    public function __construct($routeID = null)
    {
        $this
            ->setRouteID($routeID);
    }
    /**
     * Get RouteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteID()
    {
        return isset($this->RouteID) ? $this->RouteID : null;
    }
    /**
     * Set RouteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeID
     * @return \Pcm\StructType\PcmReport
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        if (is_null($routeID) || (is_array($routeID) && empty($routeID))) {
            unset($this->RouteID);
        } else {
            $this->RouteID = $routeID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
