<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmMapRequestBody extends AbstractStructBase
{
    /**
     * The Viewport
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Pcm\StructType\PcmMapViewport
     */
    public $Viewport;
    /**
     * The Projection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Projection;
    /**
     * The Style
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Style;
    /**
     * The ImageOption
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageOption;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Width;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Height;
    /**
     * The Drawers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfDrawerType
     */
    public $Drawers;
    /**
     * The LegendDrawer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfLegend
     */
    public $LegendDrawer;
    /**
     * The GeometryDrawer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfGeometry
     */
    public $GeometryDrawer;
    /**
     * The PinDrawer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmPinDrawer
     */
    public $PinDrawer;
    /**
     * The PinCategories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfPinCategory
     */
    public $PinCategories;
    /**
     * The TrafficDrawer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmTrafficDrawer
     */
    public $TrafficDrawer;
    /**
     * The MapLayering
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MapLayering;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The ImageSource
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageSource;
    /**
     * Constructor method for MapRequestBody
     * @uses PcmMapRequestBody::setViewport()
     * @uses PcmMapRequestBody::setProjection()
     * @uses PcmMapRequestBody::setStyle()
     * @uses PcmMapRequestBody::setImageOption()
     * @uses PcmMapRequestBody::setWidth()
     * @uses PcmMapRequestBody::setHeight()
     * @uses PcmMapRequestBody::setDrawers()
     * @uses PcmMapRequestBody::setLegendDrawer()
     * @uses PcmMapRequestBody::setGeometryDrawer()
     * @uses PcmMapRequestBody::setPinDrawer()
     * @uses PcmMapRequestBody::setPinCategories()
     * @uses PcmMapRequestBody::setTrafficDrawer()
     * @uses PcmMapRequestBody::setMapLayering()
     * @uses PcmMapRequestBody::setLanguage()
     * @uses PcmMapRequestBody::setImageSource()
     * @param \Pcm\StructType\PcmMapViewport $viewport
     * @param string $projection
     * @param string $style
     * @param string $imageOption
     * @param int $width
     * @param int $height
     * @param \Pcm\ArrayType\PcmArrayOfDrawerType $drawers
     * @param \Pcm\ArrayType\PcmArrayOfLegend $legendDrawer
     * @param \Pcm\ArrayType\PcmArrayOfGeometry $geometryDrawer
     * @param \Pcm\StructType\PcmPinDrawer $pinDrawer
     * @param \Pcm\ArrayType\PcmArrayOfPinCategory $pinCategories
     * @param \Pcm\StructType\PcmTrafficDrawer $trafficDrawer
     * @param string $mapLayering
     * @param string $language
     * @param string $imageSource
     */
    public function __construct(\Pcm\StructType\PcmMapViewport $viewport = null, $projection = null, $style = null, $imageOption = null, $width = null, $height = null, \Pcm\ArrayType\PcmArrayOfDrawerType $drawers = null, \Pcm\ArrayType\PcmArrayOfLegend $legendDrawer = null, \Pcm\ArrayType\PcmArrayOfGeometry $geometryDrawer = null, \Pcm\StructType\PcmPinDrawer $pinDrawer = null, \Pcm\ArrayType\PcmArrayOfPinCategory $pinCategories = null, \Pcm\StructType\PcmTrafficDrawer $trafficDrawer = null, $mapLayering = null, $language = null, $imageSource = null)
    {
        $this
            ->setViewport($viewport)
            ->setProjection($projection)
            ->setStyle($style)
            ->setImageOption($imageOption)
            ->setWidth($width)
            ->setHeight($height)
            ->setDrawers($drawers)
            ->setLegendDrawer($legendDrawer)
            ->setGeometryDrawer($geometryDrawer)
            ->setPinDrawer($pinDrawer)
            ->setPinCategories($pinCategories)
            ->setTrafficDrawer($trafficDrawer)
            ->setMapLayering($mapLayering)
            ->setLanguage($language)
            ->setImageSource($imageSource);
    }
    /**
     * Get Viewport value
     * @return \Pcm\StructType\PcmMapViewport|null
     */
    public function getViewport()
    {
        return $this->Viewport;
    }
    /**
     * Set Viewport value
     * @param \Pcm\StructType\PcmMapViewport $viewport
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setViewport(\Pcm\StructType\PcmMapViewport $viewport = null)
    {
        $this->Viewport = $viewport;
        return $this;
    }
    /**
     * Get Projection value
     * @return string|null
     */
    public function getProjection()
    {
        return $this->Projection;
    }
    /**
     * Set Projection value
     * @uses \Pcm\EnumType\PcmProjectionType::valueIsValid()
     * @uses \Pcm\EnumType\PcmProjectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $projection
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setProjection($projection = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmProjectionType::valueIsValid($projection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $projection, implode(', ', \Pcm\EnumType\PcmProjectionType::getValidValues())), __LINE__);
        }
        $this->Projection = $projection;
        return $this;
    }
    /**
     * Get Style value
     * @return string|null
     */
    public function getStyle()
    {
        return $this->Style;
    }
    /**
     * Set Style value
     * @uses \Pcm\EnumType\PcmMapStyle::valueIsValid()
     * @uses \Pcm\EnumType\PcmMapStyle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $style
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setStyle($style = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmMapStyle::valueIsValid($style)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $style, implode(', ', \Pcm\EnumType\PcmMapStyle::getValidValues())), __LINE__);
        }
        $this->Style = $style;
        return $this;
    }
    /**
     * Get ImageOption value
     * @return string|null
     */
    public function getImageOption()
    {
        return $this->ImageOption;
    }
    /**
     * Set ImageOption value
     * @uses \Pcm\EnumType\PcmMapImageOption::valueIsValid()
     * @uses \Pcm\EnumType\PcmMapImageOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageOption
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setImageOption($imageOption = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmMapImageOption::valueIsValid($imageOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $imageOption, implode(', ', \Pcm\EnumType\PcmMapImageOption::getValidValues())), __LINE__);
        }
        $this->ImageOption = $imageOption;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !is_numeric($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !is_numeric($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Drawers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfDrawerType|null
     */
    public function getDrawers()
    {
        return isset($this->Drawers) ? $this->Drawers : null;
    }
    /**
     * Set Drawers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfDrawerType $drawers
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setDrawers(\Pcm\ArrayType\PcmArrayOfDrawerType $drawers = null)
    {
        if (is_null($drawers) || (is_array($drawers) && empty($drawers))) {
            unset($this->Drawers);
        } else {
            $this->Drawers = $drawers;
        }
        return $this;
    }
    /**
     * Get LegendDrawer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfLegend|null
     */
    public function getLegendDrawer()
    {
        return isset($this->LegendDrawer) ? $this->LegendDrawer : null;
    }
    /**
     * Set LegendDrawer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfLegend $legendDrawer
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setLegendDrawer(\Pcm\ArrayType\PcmArrayOfLegend $legendDrawer = null)
    {
        if (is_null($legendDrawer) || (is_array($legendDrawer) && empty($legendDrawer))) {
            unset($this->LegendDrawer);
        } else {
            $this->LegendDrawer = $legendDrawer;
        }
        return $this;
    }
    /**
     * Get GeometryDrawer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfGeometry|null
     */
    public function getGeometryDrawer()
    {
        return isset($this->GeometryDrawer) ? $this->GeometryDrawer : null;
    }
    /**
     * Set GeometryDrawer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfGeometry $geometryDrawer
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setGeometryDrawer(\Pcm\ArrayType\PcmArrayOfGeometry $geometryDrawer = null)
    {
        if (is_null($geometryDrawer) || (is_array($geometryDrawer) && empty($geometryDrawer))) {
            unset($this->GeometryDrawer);
        } else {
            $this->GeometryDrawer = $geometryDrawer;
        }
        return $this;
    }
    /**
     * Get PinDrawer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmPinDrawer|null
     */
    public function getPinDrawer()
    {
        return isset($this->PinDrawer) ? $this->PinDrawer : null;
    }
    /**
     * Set PinDrawer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmPinDrawer $pinDrawer
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setPinDrawer(\Pcm\StructType\PcmPinDrawer $pinDrawer = null)
    {
        if (is_null($pinDrawer) || (is_array($pinDrawer) && empty($pinDrawer))) {
            unset($this->PinDrawer);
        } else {
            $this->PinDrawer = $pinDrawer;
        }
        return $this;
    }
    /**
     * Get PinCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfPinCategory|null
     */
    public function getPinCategories()
    {
        return isset($this->PinCategories) ? $this->PinCategories : null;
    }
    /**
     * Set PinCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfPinCategory $pinCategories
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setPinCategories(\Pcm\ArrayType\PcmArrayOfPinCategory $pinCategories = null)
    {
        if (is_null($pinCategories) || (is_array($pinCategories) && empty($pinCategories))) {
            unset($this->PinCategories);
        } else {
            $this->PinCategories = $pinCategories;
        }
        return $this;
    }
    /**
     * Get TrafficDrawer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmTrafficDrawer|null
     */
    public function getTrafficDrawer()
    {
        return isset($this->TrafficDrawer) ? $this->TrafficDrawer : null;
    }
    /**
     * Set TrafficDrawer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmTrafficDrawer $trafficDrawer
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setTrafficDrawer(\Pcm\StructType\PcmTrafficDrawer $trafficDrawer = null)
    {
        if (is_null($trafficDrawer) || (is_array($trafficDrawer) && empty($trafficDrawer))) {
            unset($this->TrafficDrawer);
        } else {
            $this->TrafficDrawer = $trafficDrawer;
        }
        return $this;
    }
    /**
     * Get MapLayering value
     * @return string|null
     */
    public function getMapLayering()
    {
        return $this->MapLayering;
    }
    /**
     * Set MapLayering value
     * @uses \Pcm\EnumType\PcmMapLayering::valueIsValid()
     * @uses \Pcm\EnumType\PcmMapLayering::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mapLayering
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setMapLayering($mapLayering = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmMapLayering::valueIsValid($mapLayering)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mapLayering, implode(', ', \Pcm\EnumType\PcmMapLayering::getValidValues())), __LINE__);
        }
        $this->MapLayering = $mapLayering;
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get ImageSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageSource()
    {
        return isset($this->ImageSource) ? $this->ImageSource : null;
    }
    /**
     * Set ImageSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmBackgroundImageProvider::valueIsValid()
     * @uses \Pcm\EnumType\PcmBackgroundImageProvider::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageSource
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public function setImageSource($imageSource = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmBackgroundImageProvider::valueIsValid($imageSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $imageSource, implode(', ', \Pcm\EnumType\PcmBackgroundImageProvider::getValidValues())), __LINE__);
        }
        if (is_null($imageSource) || (is_array($imageSource) && empty($imageSource))) {
            unset($this->ImageSource);
        } else {
            $this->ImageSource = $imageSource;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmMapRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
