<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeocodeOutputLocation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GeocodeOutputLocation
 * @package Pcm
 * @subpackage Structs
 */
class PcmGeocodeOutputLocation extends PcmLocation
{
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZone;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfError
     */
    public $Errors;
    /**
     * The SpeedLimitInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmSpeedLimit
     */
    public $SpeedLimitInfo;
    /**
     * The ConfidenceLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfidenceLevel;
    /**
     * The DistanceFromRoad
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DistanceFromRoad;
    /**
     * The CrossStreet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrossStreet;
    /**
     * Constructor method for GeocodeOutputLocation
     * @uses PcmGeocodeOutputLocation::setTimeZone()
     * @uses PcmGeocodeOutputLocation::setErrors()
     * @uses PcmGeocodeOutputLocation::setSpeedLimitInfo()
     * @uses PcmGeocodeOutputLocation::setConfidenceLevel()
     * @uses PcmGeocodeOutputLocation::setDistanceFromRoad()
     * @uses PcmGeocodeOutputLocation::setCrossStreet()
     * @param string $timeZone
     * @param \Pcm\ArrayType\PcmArrayOfError $errors
     * @param \Pcm\StructType\PcmSpeedLimit $speedLimitInfo
     * @param string $confidenceLevel
     * @param float $distanceFromRoad
     * @param string $crossStreet
     */
    public function __construct($timeZone = null, \Pcm\ArrayType\PcmArrayOfError $errors = null, \Pcm\StructType\PcmSpeedLimit $speedLimitInfo = null, $confidenceLevel = null, $distanceFromRoad = null, $crossStreet = null)
    {
        $this
            ->setTimeZone($timeZone)
            ->setErrors($errors)
            ->setSpeedLimitInfo($speedLimitInfo)
            ->setConfidenceLevel($confidenceLevel)
            ->setDistanceFromRoad($distanceFromRoad)
            ->setCrossStreet($crossStreet);
    }
    /**
     * Get TimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZone()
    {
        return isset($this->TimeZone) ? $this->TimeZone : null;
    }
    /**
     * Set TimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZone
     * @return \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeZone)), __LINE__);
        }
        if (is_null($timeZone) || (is_array($timeZone) && empty($timeZone))) {
            unset($this->TimeZone);
        } else {
            $this->TimeZone = $timeZone;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfError|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfError $errors
     * @return \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public function setErrors(\Pcm\ArrayType\PcmArrayOfError $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get SpeedLimitInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmSpeedLimit|null
     */
    public function getSpeedLimitInfo()
    {
        return isset($this->SpeedLimitInfo) ? $this->SpeedLimitInfo : null;
    }
    /**
     * Set SpeedLimitInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmSpeedLimit $speedLimitInfo
     * @return \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public function setSpeedLimitInfo(\Pcm\StructType\PcmSpeedLimit $speedLimitInfo = null)
    {
        if (is_null($speedLimitInfo) || (is_array($speedLimitInfo) && empty($speedLimitInfo))) {
            unset($this->SpeedLimitInfo);
        } else {
            $this->SpeedLimitInfo = $speedLimitInfo;
        }
        return $this;
    }
    /**
     * Get ConfidenceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfidenceLevel()
    {
        return isset($this->ConfidenceLevel) ? $this->ConfidenceLevel : null;
    }
    /**
     * Set ConfidenceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confidenceLevel
     * @return \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public function setConfidenceLevel($confidenceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($confidenceLevel) && !is_string($confidenceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confidenceLevel)), __LINE__);
        }
        if (is_null($confidenceLevel) || (is_array($confidenceLevel) && empty($confidenceLevel))) {
            unset($this->ConfidenceLevel);
        } else {
            $this->ConfidenceLevel = $confidenceLevel;
        }
        return $this;
    }
    /**
     * Get DistanceFromRoad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDistanceFromRoad()
    {
        return isset($this->DistanceFromRoad) ? $this->DistanceFromRoad : null;
    }
    /**
     * Set DistanceFromRoad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $distanceFromRoad
     * @return \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public function setDistanceFromRoad($distanceFromRoad = null)
    {
        if (is_null($distanceFromRoad) || (is_array($distanceFromRoad) && empty($distanceFromRoad))) {
            unset($this->DistanceFromRoad);
        } else {
            $this->DistanceFromRoad = $distanceFromRoad;
        }
        return $this;
    }
    /**
     * Get CrossStreet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrossStreet()
    {
        return isset($this->CrossStreet) ? $this->CrossStreet : null;
    }
    /**
     * Set CrossStreet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crossStreet
     * @return \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public function setCrossStreet($crossStreet = null)
    {
        // validation for constraint: string
        if (!is_null($crossStreet) && !is_string($crossStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($crossStreet)), __LINE__);
        }
        if (is_null($crossStreet) || (is_array($crossStreet) && empty($crossStreet))) {
            unset($this->CrossStreet);
        } else {
            $this->CrossStreet = $crossStreet;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
