<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRouteSyncMsgRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateRouteSyncMsgRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmCreateRouteSyncMsgRequestBody extends AbstractStructBase
{
    /**
     * The OutOfRouteDistance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OutOfRouteDistance;
    /**
     * The Compliance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Compliance;
    /**
     * The IsFirstLegManaged
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFirstLegManaged;
    /**
     * The ManagedRoute
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmExtendedRoute
     */
    public $ManagedRoute;
    /**
     * The CreateRouteSyncFromPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CreateRouteSyncFromPoints;
    /**
     * The MessageVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MessageVersion;
    /**
     * Constructor method for CreateRouteSyncMsgRequestBody
     * @uses PcmCreateRouteSyncMsgRequestBody::setOutOfRouteDistance()
     * @uses PcmCreateRouteSyncMsgRequestBody::setCompliance()
     * @uses PcmCreateRouteSyncMsgRequestBody::setIsFirstLegManaged()
     * @uses PcmCreateRouteSyncMsgRequestBody::setManagedRoute()
     * @uses PcmCreateRouteSyncMsgRequestBody::setCreateRouteSyncFromPoints()
     * @uses PcmCreateRouteSyncMsgRequestBody::setMessageVersion()
     * @param float $outOfRouteDistance
     * @param string $compliance
     * @param bool $isFirstLegManaged
     * @param \Pcm\StructType\PcmExtendedRoute $managedRoute
     * @param bool $createRouteSyncFromPoints
     * @param string $messageVersion
     */
    public function __construct($outOfRouteDistance = null, $compliance = null, $isFirstLegManaged = null, \Pcm\StructType\PcmExtendedRoute $managedRoute = null, $createRouteSyncFromPoints = null, $messageVersion = null)
    {
        $this
            ->setOutOfRouteDistance($outOfRouteDistance)
            ->setCompliance($compliance)
            ->setIsFirstLegManaged($isFirstLegManaged)
            ->setManagedRoute($managedRoute)
            ->setCreateRouteSyncFromPoints($createRouteSyncFromPoints)
            ->setMessageVersion($messageVersion);
    }
    /**
     * Get OutOfRouteDistance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOutOfRouteDistance()
    {
        return isset($this->OutOfRouteDistance) ? $this->OutOfRouteDistance : null;
    }
    /**
     * Set OutOfRouteDistance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $outOfRouteDistance
     * @return \Pcm\StructType\PcmCreateRouteSyncMsgRequestBody
     */
    public function setOutOfRouteDistance($outOfRouteDistance = null)
    {
        if (is_null($outOfRouteDistance) || (is_array($outOfRouteDistance) && empty($outOfRouteDistance))) {
            unset($this->OutOfRouteDistance);
        } else {
            $this->OutOfRouteDistance = $outOfRouteDistance;
        }
        return $this;
    }
    /**
     * Get Compliance value
     * @return string|null
     */
    public function getCompliance()
    {
        return $this->Compliance;
    }
    /**
     * Set Compliance value
     * @uses \Pcm\EnumType\PcmOutOfRouteCompliance::valueIsValid()
     * @uses \Pcm\EnumType\PcmOutOfRouteCompliance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $compliance
     * @return \Pcm\StructType\PcmCreateRouteSyncMsgRequestBody
     */
    public function setCompliance($compliance = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmOutOfRouteCompliance::valueIsValid($compliance)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $compliance, implode(', ', \Pcm\EnumType\PcmOutOfRouteCompliance::getValidValues())), __LINE__);
        }
        $this->Compliance = $compliance;
        return $this;
    }
    /**
     * Get IsFirstLegManaged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFirstLegManaged()
    {
        return isset($this->IsFirstLegManaged) ? $this->IsFirstLegManaged : null;
    }
    /**
     * Set IsFirstLegManaged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFirstLegManaged
     * @return \Pcm\StructType\PcmCreateRouteSyncMsgRequestBody
     */
    public function setIsFirstLegManaged($isFirstLegManaged = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstLegManaged) && !is_bool($isFirstLegManaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFirstLegManaged)), __LINE__);
        }
        if (is_null($isFirstLegManaged) || (is_array($isFirstLegManaged) && empty($isFirstLegManaged))) {
            unset($this->IsFirstLegManaged);
        } else {
            $this->IsFirstLegManaged = $isFirstLegManaged;
        }
        return $this;
    }
    /**
     * Get ManagedRoute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmExtendedRoute|null
     */
    public function getManagedRoute()
    {
        return isset($this->ManagedRoute) ? $this->ManagedRoute : null;
    }
    /**
     * Set ManagedRoute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmExtendedRoute $managedRoute
     * @return \Pcm\StructType\PcmCreateRouteSyncMsgRequestBody
     */
    public function setManagedRoute(\Pcm\StructType\PcmExtendedRoute $managedRoute = null)
    {
        if (is_null($managedRoute) || (is_array($managedRoute) && empty($managedRoute))) {
            unset($this->ManagedRoute);
        } else {
            $this->ManagedRoute = $managedRoute;
        }
        return $this;
    }
    /**
     * Get CreateRouteSyncFromPoints value
     * @return bool|null
     */
    public function getCreateRouteSyncFromPoints()
    {
        return $this->CreateRouteSyncFromPoints;
    }
    /**
     * Set CreateRouteSyncFromPoints value
     * @param bool $createRouteSyncFromPoints
     * @return \Pcm\StructType\PcmCreateRouteSyncMsgRequestBody
     */
    public function setCreateRouteSyncFromPoints($createRouteSyncFromPoints = null)
    {
        // validation for constraint: boolean
        if (!is_null($createRouteSyncFromPoints) && !is_bool($createRouteSyncFromPoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($createRouteSyncFromPoints)), __LINE__);
        }
        $this->CreateRouteSyncFromPoints = $createRouteSyncFromPoints;
        return $this;
    }
    /**
     * Get MessageVersion value
     * @return string|null
     */
    public function getMessageVersion()
    {
        return $this->MessageVersion;
    }
    /**
     * Set MessageVersion value
     * @uses \Pcm\EnumType\PcmRouteSyncMessageVersion::valueIsValid()
     * @uses \Pcm\EnumType\PcmRouteSyncMessageVersion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageVersion
     * @return \Pcm\StructType\PcmCreateRouteSyncMsgRequestBody
     */
    public function setMessageVersion($messageVersion = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmRouteSyncMessageVersion::valueIsValid($messageVersion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $messageVersion, implode(', ', \Pcm\EnumType\PcmRouteSyncMessageVersion::getValidValues())), __LINE__);
        }
        $this->MessageVersion = $messageVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmCreateRouteSyncMsgRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
