<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthHeader StructType
 * @package Pcm
 * @subpackage Structs
 */
class PcmAuthHeader extends AbstractStructBase
{
    /**
     * The Authorization
     * @var string
     */
    public $Authorization;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * Constructor method for AuthHeader
     * @uses PcmAuthHeader::setAuthorization()
     * @uses PcmAuthHeader::setDate()
     * @param string $authorization
     * @param string $date
     */
    public function __construct($authorization = null, $date = null)
    {
        $this
            ->setAuthorization($authorization)
            ->setDate($date);
    }
    /**
     * Get Authorization value
     * @return string|null
     */
    public function getAuthorization()
    {
        return $this->Authorization;
    }
    /**
     * Set Authorization value
     * @param string $authorization
     * @return \Pcm\StructType\PcmAuthHeader
     */
    public function setAuthorization($authorization = null)
    {
        // validation for constraint: string
        if (!is_null($authorization) && !is_string($authorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorization)), __LINE__);
        }
        $this->Authorization = $authorization;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Pcm\StructType\PcmAuthHeader
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAuthHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
