<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateHosLocation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AlternateHosLocation
 * @package Pcm
 * @subpackage Structs
 */
class PcmAlternateHosLocation extends PcmLocation
{
    /**
     * The Amenities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfstring
     */
    public $Amenities;
    /**
     * The TruckServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TruckServices;
    /**
     * Constructor method for AlternateHosLocation
     * @uses PcmAlternateHosLocation::setAmenities()
     * @uses PcmAlternateHosLocation::setTruckServices()
     * @param \Pcm\ArrayType\PcmArrayOfstring $amenities
     * @param bool $truckServices
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfstring $amenities = null, $truckServices = null)
    {
        $this
            ->setAmenities($amenities)
            ->setTruckServices($truckServices);
    }
    /**
     * Get Amenities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfstring|null
     */
    public function getAmenities()
    {
        return isset($this->Amenities) ? $this->Amenities : null;
    }
    /**
     * Set Amenities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfstring $amenities
     * @return \Pcm\StructType\PcmAlternateHosLocation
     */
    public function setAmenities(\Pcm\ArrayType\PcmArrayOfstring $amenities = null)
    {
        if (is_null($amenities) || (is_array($amenities) && empty($amenities))) {
            unset($this->Amenities);
        } else {
            $this->Amenities = $amenities;
        }
        return $this;
    }
    /**
     * Get TruckServices value
     * @return bool|null
     */
    public function getTruckServices()
    {
        return $this->TruckServices;
    }
    /**
     * Set TruckServices value
     * @param bool $truckServices
     * @return \Pcm\StructType\PcmAlternateHosLocation
     */
    public function setTruckServices($truckServices = null)
    {
        // validation for constraint: boolean
        if (!is_null($truckServices) && !is_bool($truckServices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($truckServices)), __LINE__);
        }
        $this->TruckServices = $truckServices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAlternateHosLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
