<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALKFont StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ALKFont
 * @package Pcm
 * @subpackage Structs
 */
class PcmALKFont extends AbstractStructBase
{
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRGB
     */
    public $Color;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Height;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for ALKFont
     * @uses PcmALKFont::setColor()
     * @uses PcmALKFont::setHeight()
     * @uses PcmALKFont::setWeight()
     * @param \Pcm\StructType\PcmRGB $color
     * @param string $height
     * @param string $weight
     */
    public function __construct(\Pcm\StructType\PcmRGB $color = null, $height = null, $weight = null)
    {
        $this
            ->setColor($color)
            ->setHeight($height)
            ->setWeight($weight);
    }
    /**
     * Get Color value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRGB|null
     */
    public function getColor()
    {
        return isset($this->Color) ? $this->Color : null;
    }
    /**
     * Set Color value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRGB $color
     * @return \Pcm\StructType\PcmALKFont
     */
    public function setColor(\Pcm\StructType\PcmRGB $color = null)
    {
        if (is_null($color) || (is_array($color) && empty($color))) {
            unset($this->Color);
        } else {
            $this->Color = $color;
        }
        return $this;
    }
    /**
     * Get Height value
     * @return string|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param string $height
     * @return \Pcm\StructType\PcmALKFont
     */
    public function setHeight($height = null)
    {
        // validation for constraint: string
        if (!is_null($height) && !is_string($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Pcm\StructType\PcmALKFont
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmALKFont
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
