<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AFLink StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AFLink
 * @package Pcm
 * @subpackage Structs
 */
class PcmAFLink extends AbstractStructBase
{
    /**
     * The AFGroupID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AFGroupID;
    /**
     * The AvoidFavorID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AvoidFavorID;
    /**
     * The AvoidFavorType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AvoidFavorType;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The ExtraInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmAFExtraInfo
     */
    public $ExtraInfo;
    /**
     * The Geometries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfArrayOfArrayOfdouble
     */
    public $Geometries;
    /**
     * The GridID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GridID;
    /**
     * The GridLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GridLevel;
    /**
     * The LinkID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LinkID;
    /**
     * The LinkPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfArrayOfint
     */
    public $LinkPoints;
    /**
     * The PLIDs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfint
     */
    public $PLIDs;
    /**
     * Constructor method for AFLink
     * @uses PcmAFLink::setAFGroupID()
     * @uses PcmAFLink::setAvoidFavorID()
     * @uses PcmAFLink::setAvoidFavorType()
     * @uses PcmAFLink::setComment()
     * @uses PcmAFLink::setExtraInfo()
     * @uses PcmAFLink::setGeometries()
     * @uses PcmAFLink::setGridID()
     * @uses PcmAFLink::setGridLevel()
     * @uses PcmAFLink::setLinkID()
     * @uses PcmAFLink::setLinkPoints()
     * @uses PcmAFLink::setPLIDs()
     * @param int $aFGroupID
     * @param int $avoidFavorID
     * @param string $avoidFavorType
     * @param string $comment
     * @param \Pcm\StructType\PcmAFExtraInfo $extraInfo
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfArrayOfdouble $geometries
     * @param int $gridID
     * @param int $gridLevel
     * @param int $linkID
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfint $linkPoints
     * @param \Pcm\ArrayType\PcmArrayOfint $pLIDs
     */
    public function __construct($aFGroupID = null, $avoidFavorID = null, $avoidFavorType = null, $comment = null, \Pcm\StructType\PcmAFExtraInfo $extraInfo = null, \Pcm\ArrayType\PcmArrayOfArrayOfArrayOfdouble $geometries = null, $gridID = null, $gridLevel = null, $linkID = null, \Pcm\ArrayType\PcmArrayOfArrayOfint $linkPoints = null, \Pcm\ArrayType\PcmArrayOfint $pLIDs = null)
    {
        $this
            ->setAFGroupID($aFGroupID)
            ->setAvoidFavorID($avoidFavorID)
            ->setAvoidFavorType($avoidFavorType)
            ->setComment($comment)
            ->setExtraInfo($extraInfo)
            ->setGeometries($geometries)
            ->setGridID($gridID)
            ->setGridLevel($gridLevel)
            ->setLinkID($linkID)
            ->setLinkPoints($linkPoints)
            ->setPLIDs($pLIDs);
    }
    /**
     * Get AFGroupID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAFGroupID()
    {
        return isset($this->AFGroupID) ? $this->AFGroupID : null;
    }
    /**
     * Set AFGroupID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aFGroupID
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setAFGroupID($aFGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($aFGroupID) && !is_numeric($aFGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aFGroupID)), __LINE__);
        }
        if (is_null($aFGroupID) || (is_array($aFGroupID) && empty($aFGroupID))) {
            unset($this->AFGroupID);
        } else {
            $this->AFGroupID = $aFGroupID;
        }
        return $this;
    }
    /**
     * Get AvoidFavorID value
     * @return int|null
     */
    public function getAvoidFavorID()
    {
        return $this->AvoidFavorID;
    }
    /**
     * Set AvoidFavorID value
     * @param int $avoidFavorID
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setAvoidFavorID($avoidFavorID = null)
    {
        // validation for constraint: int
        if (!is_null($avoidFavorID) && !is_numeric($avoidFavorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($avoidFavorID)), __LINE__);
        }
        $this->AvoidFavorID = $avoidFavorID;
        return $this;
    }
    /**
     * Get AvoidFavorType value
     * @return string|null
     */
    public function getAvoidFavorType()
    {
        return $this->AvoidFavorType;
    }
    /**
     * Set AvoidFavorType value
     * @uses \Pcm\EnumType\PcmAFType::valueIsValid()
     * @uses \Pcm\EnumType\PcmAFType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $avoidFavorType
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setAvoidFavorType($avoidFavorType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmAFType::valueIsValid($avoidFavorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $avoidFavorType, implode(', ', \Pcm\EnumType\PcmAFType::getValidValues())), __LINE__);
        }
        $this->AvoidFavorType = $avoidFavorType;
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmAFExtraInfo|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmAFExtraInfo $extraInfo
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setExtraInfo(\Pcm\StructType\PcmAFExtraInfo $extraInfo = null)
    {
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get Geometries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfArrayOfdouble|null
     */
    public function getGeometries()
    {
        return isset($this->Geometries) ? $this->Geometries : null;
    }
    /**
     * Set Geometries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfArrayOfdouble $geometries
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setGeometries(\Pcm\ArrayType\PcmArrayOfArrayOfArrayOfdouble $geometries = null)
    {
        if (is_null($geometries) || (is_array($geometries) && empty($geometries))) {
            unset($this->Geometries);
        } else {
            $this->Geometries = $geometries;
        }
        return $this;
    }
    /**
     * Get GridID value
     * @return int|null
     */
    public function getGridID()
    {
        return $this->GridID;
    }
    /**
     * Set GridID value
     * @param int $gridID
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setGridID($gridID = null)
    {
        // validation for constraint: int
        if (!is_null($gridID) && !is_numeric($gridID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gridID)), __LINE__);
        }
        $this->GridID = $gridID;
        return $this;
    }
    /**
     * Get GridLevel value
     * @return int|null
     */
    public function getGridLevel()
    {
        return $this->GridLevel;
    }
    /**
     * Set GridLevel value
     * @param int $gridLevel
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setGridLevel($gridLevel = null)
    {
        // validation for constraint: int
        if (!is_null($gridLevel) && !is_numeric($gridLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gridLevel)), __LINE__);
        }
        $this->GridLevel = $gridLevel;
        return $this;
    }
    /**
     * Get LinkID value
     * @return int|null
     */
    public function getLinkID()
    {
        return $this->LinkID;
    }
    /**
     * Set LinkID value
     * @param int $linkID
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setLinkID($linkID = null)
    {
        // validation for constraint: int
        if (!is_null($linkID) && !is_numeric($linkID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($linkID)), __LINE__);
        }
        $this->LinkID = $linkID;
        return $this;
    }
    /**
     * Get LinkPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfint|null
     */
    public function getLinkPoints()
    {
        return isset($this->LinkPoints) ? $this->LinkPoints : null;
    }
    /**
     * Set LinkPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfint $linkPoints
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setLinkPoints(\Pcm\ArrayType\PcmArrayOfArrayOfint $linkPoints = null)
    {
        if (is_null($linkPoints) || (is_array($linkPoints) && empty($linkPoints))) {
            unset($this->LinkPoints);
        } else {
            $this->LinkPoints = $linkPoints;
        }
        return $this;
    }
    /**
     * Get PLIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfint|null
     */
    public function getPLIDs()
    {
        return isset($this->PLIDs) ? $this->PLIDs : null;
    }
    /**
     * Set PLIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfint $pLIDs
     * @return \Pcm\StructType\PcmAFLink
     */
    public function setPLIDs(\Pcm\ArrayType\PcmArrayOfint $pLIDs = null)
    {
        if (is_null($pLIDs) || (is_array($pLIDs) && empty($pLIDs))) {
            unset($this->PLIDs);
        } else {
            $this->PLIDs = $pLIDs;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAFLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
