<?php

namespace Pcm\EnumType;

/**
 * This class stands for TruckStyle EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TruckStyle
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmTruckStyle
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'TwentyEightDoubleTrailer'
     * @return string 'TwentyEightDoubleTrailer'
     */
    const VALUE_TWENTY_EIGHT_DOUBLE_TRAILER = 'TwentyEightDoubleTrailer';
    /**
     * Constant for value 'FortyStraightTruck'
     * @return string 'FortyStraightTruck'
     */
    const VALUE_FORTY_STRAIGHT_TRUCK = 'FortyStraightTruck';
    /**
     * Constant for value 'FortyEightSemiTrailer'
     * @return string 'FortyEightSemiTrailer'
     */
    const VALUE_FORTY_EIGHT_SEMI_TRAILER = 'FortyEightSemiTrailer';
    /**
     * Constant for value 'FiftyThreeSemiTrailer'
     * @return string 'FiftyThreeSemiTrailer'
     */
    const VALUE_FIFTY_THREE_SEMI_TRAILER = 'FiftyThreeSemiTrailer';
    /**
     * Constant for value 'FullSizeVan'
     * @return string 'FullSizeVan'
     */
    const VALUE_FULL_SIZE_VAN = 'FullSizeVan';
    /**
     * Constant for value 'TwentySixStraightTruck'
     * @return string 'TwentySixStraightTruck'
     */
    const VALUE_TWENTY_SIX_STRAIGHT_TRUCK = 'TwentySixStraightTruck';
    /**
     * Constant for value 'ConventionalSchoolBus'
     * @return string 'ConventionalSchoolBus'
     */
    const VALUE_CONVENTIONAL_SCHOOL_BUS = 'ConventionalSchoolBus';
    /**
     * Constant for value 'SmallSchoolBus'
     * @return string 'SmallSchoolBus'
     */
    const VALUE_SMALL_SCHOOL_BUS = 'SmallSchoolBus';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_TWENTY_EIGHT_DOUBLE_TRAILER
     * @uses self::VALUE_FORTY_STRAIGHT_TRUCK
     * @uses self::VALUE_FORTY_EIGHT_SEMI_TRAILER
     * @uses self::VALUE_FIFTY_THREE_SEMI_TRAILER
     * @uses self::VALUE_FULL_SIZE_VAN
     * @uses self::VALUE_TWENTY_SIX_STRAIGHT_TRUCK
     * @uses self::VALUE_CONVENTIONAL_SCHOOL_BUS
     * @uses self::VALUE_SMALL_SCHOOL_BUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_TWENTY_EIGHT_DOUBLE_TRAILER,
            self::VALUE_FORTY_STRAIGHT_TRUCK,
            self::VALUE_FORTY_EIGHT_SEMI_TRAILER,
            self::VALUE_FIFTY_THREE_SEMI_TRAILER,
            self::VALUE_FULL_SIZE_VAN,
            self::VALUE_TWENTY_SIX_STRAIGHT_TRUCK,
            self::VALUE_CONVENTIONAL_SCHOOL_BUS,
            self::VALUE_SMALL_SCHOOL_BUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
