<?php

namespace Pcm\EnumType;

/**
 * This class stands for TrafficTime EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrafficTime
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmTrafficTime
{
    /**
     * Constant for value 'Actual'
     * @return string 'Actual'
     */
    const VALUE_ACTUAL = 'Actual';
    /**
     * Constant for value 'Historic'
     * @return string 'Historic'
     */
    const VALUE_HISTORIC = 'Historic';
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTUAL
     * @uses self::VALUE_HISTORIC
     * @uses self::VALUE_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTUAL,
            self::VALUE_HISTORIC,
            self::VALUE_DEFAULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
