<?php

namespace Pcm\EnumType;

/**
 * This class stands for HazMatType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HazMatType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmHazMatType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'General'
     * @return string 'General'
     */
    const VALUE_GENERAL = 'General';
    /**
     * Constant for value 'Caustic'
     * @return string 'Caustic'
     */
    const VALUE_CAUSTIC = 'Caustic';
    /**
     * Constant for value 'Explosives'
     * @return string 'Explosives'
     */
    const VALUE_EXPLOSIVES = 'Explosives';
    /**
     * Constant for value 'Flammable'
     * @return string 'Flammable'
     */
    const VALUE_FLAMMABLE = 'Flammable';
    /**
     * Constant for value 'Inhalants'
     * @return string 'Inhalants'
     */
    const VALUE_INHALANTS = 'Inhalants';
    /**
     * Constant for value 'Radioactive'
     * @return string 'Radioactive'
     */
    const VALUE_RADIOACTIVE = 'Radioactive';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_GENERAL
     * @uses self::VALUE_CAUSTIC
     * @uses self::VALUE_EXPLOSIVES
     * @uses self::VALUE_FLAMMABLE
     * @uses self::VALUE_INHALANTS
     * @uses self::VALUE_RADIOACTIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_GENERAL,
            self::VALUE_CAUSTIC,
            self::VALUE_EXPLOSIVES,
            self::VALUE_FLAMMABLE,
            self::VALUE_INHALANTS,
            self::VALUE_RADIOACTIVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
