<?php

namespace Pcm\EnumType;

/**
 * This class stands for ErrorType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ErrorType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmErrorType
{
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'Exception'
     * @return string 'Exception'
     */
    const VALUE_EXCEPTION = 'Exception';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_EXCEPTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WARNING,
            self::VALUE_EXCEPTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
