<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfdouble ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfdouble
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfdouble extends AbstractStructArrayBase
{
    /**
     * The double
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $double;
    /**
     * Constructor method for ArrayOfdouble
     * @uses PcmArrayOfdouble::setDouble()
     * @param float[] $double
     */
    public function __construct(array $double = array())
    {
        $this
            ->setDouble($double);
    }
    /**
     * Get double value
     * @return float[]|null
     */
    public function getDouble()
    {
        return $this->double;
    }
    /**
     * Set double value
     * @throws \InvalidArgumentException
     * @param float[] $double
     * @return \Pcm\ArrayType\PcmArrayOfdouble
     */
    public function setDouble(array $double = array())
    {
        foreach ($double as $arrayOfdoubleDoubleItem) {
            // validation for constraint: itemType
            if (!is_float($arrayOfdoubleDoubleItem)) {
                throw new \InvalidArgumentException(sprintf('The double property can only contain items of double, "%s" given', is_object($arrayOfdoubleDoubleItem) ? get_class($arrayOfdoubleDoubleItem) : gettype($arrayOfdoubleDoubleItem)), __LINE__);
            }
        }
        $this->double = $double;
        return $this;
    }
    /**
     * Add item to double value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \Pcm\ArrayType\PcmArrayOfdouble
     */
    public function addToDouble($item)
    {
        // validation for constraint: itemType
        if (!is_float($item)) {
            throw new \InvalidArgumentException(sprintf('The double property can only contain items of double, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->double[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return float|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return float|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return float|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return float|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return float|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string double
     */
    public function getAttributeName()
    {
        return 'double';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfdouble
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
