<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStateCountry ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStateCountry
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfStateCountry extends AbstractStructArrayBase
{
    /**
     * The StateCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmStateCountry[]
     */
    public $StateCountry;
    /**
     * Constructor method for ArrayOfStateCountry
     * @uses PcmArrayOfStateCountry::setStateCountry()
     * @param \Pcm\StructType\PcmStateCountry[] $stateCountry
     */
    public function __construct(array $stateCountry = array())
    {
        $this
            ->setStateCountry($stateCountry);
    }
    /**
     * Get StateCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmStateCountry[]|null
     */
    public function getStateCountry()
    {
        return isset($this->StateCountry) ? $this->StateCountry : null;
    }
    /**
     * Set StateCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmStateCountry[] $stateCountry
     * @return \Pcm\ArrayType\PcmArrayOfStateCountry
     */
    public function setStateCountry(array $stateCountry = array())
    {
        foreach ($stateCountry as $arrayOfStateCountryStateCountryItem) {
            // validation for constraint: itemType
            if (!$arrayOfStateCountryStateCountryItem instanceof \Pcm\StructType\PcmStateCountry) {
                throw new \InvalidArgumentException(sprintf('The StateCountry property can only contain items of \Pcm\StructType\PcmStateCountry, "%s" given', is_object($arrayOfStateCountryStateCountryItem) ? get_class($arrayOfStateCountryStateCountryItem) : gettype($arrayOfStateCountryStateCountryItem)), __LINE__);
            }
        }
        if (is_null($stateCountry) || (is_array($stateCountry) && empty($stateCountry))) {
            unset($this->StateCountry);
        } else {
            $this->StateCountry = $stateCountry;
        }
        return $this;
    }
    /**
     * Add item to StateCountry value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmStateCountry $item
     * @return \Pcm\ArrayType\PcmArrayOfStateCountry
     */
    public function addToStateCountry(\Pcm\StructType\PcmStateCountry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmStateCountry) {
            throw new \InvalidArgumentException(sprintf('The StateCountry property can only contain items of \Pcm\StructType\PcmStateCountry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StateCountry[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmStateCountry|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmStateCountry|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmStateCountry|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmStateCountry|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmStateCountry|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StateCountry
     */
    public function getAttributeName()
    {
        return 'StateCountry';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfStateCountry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
