<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLegend ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLegend
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfLegend extends AbstractStructArrayBase
{
    /**
     * The Legend
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmLegend[]
     */
    public $Legend;
    /**
     * Constructor method for ArrayOfLegend
     * @uses PcmArrayOfLegend::setLegend()
     * @param \Pcm\StructType\PcmLegend[] $legend
     */
    public function __construct(array $legend = array())
    {
        $this
            ->setLegend($legend);
    }
    /**
     * Get Legend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmLegend[]|null
     */
    public function getLegend()
    {
        return isset($this->Legend) ? $this->Legend : null;
    }
    /**
     * Set Legend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmLegend[] $legend
     * @return \Pcm\ArrayType\PcmArrayOfLegend
     */
    public function setLegend(array $legend = array())
    {
        foreach ($legend as $arrayOfLegendLegendItem) {
            // validation for constraint: itemType
            if (!$arrayOfLegendLegendItem instanceof \Pcm\StructType\PcmLegend) {
                throw new \InvalidArgumentException(sprintf('The Legend property can only contain items of \Pcm\StructType\PcmLegend, "%s" given', is_object($arrayOfLegendLegendItem) ? get_class($arrayOfLegendLegendItem) : gettype($arrayOfLegendLegendItem)), __LINE__);
            }
        }
        if (is_null($legend) || (is_array($legend) && empty($legend))) {
            unset($this->Legend);
        } else {
            $this->Legend = $legend;
        }
        return $this;
    }
    /**
     * Add item to Legend value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmLegend $item
     * @return \Pcm\ArrayType\PcmArrayOfLegend
     */
    public function addToLegend(\Pcm\StructType\PcmLegend $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmLegend) {
            throw new \InvalidArgumentException(sprintf('The Legend property can only contain items of \Pcm\StructType\PcmLegend, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Legend[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmLegend|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmLegend|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmLegend|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmLegend|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmLegend|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Legend
     */
    public function getAttributeName()
    {
        return 'Legend';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfLegend
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
