<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGeocodeOutputLocation ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfGeocodeOutputLocation
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfGeocodeOutputLocation extends AbstractStructArrayBase
{
    /**
     * The GeocodeOutputLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmGeocodeOutputLocation[]
     */
    public $GeocodeOutputLocation;
    /**
     * Constructor method for ArrayOfGeocodeOutputLocation
     * @uses PcmArrayOfGeocodeOutputLocation::setGeocodeOutputLocation()
     * @param \Pcm\StructType\PcmGeocodeOutputLocation[] $geocodeOutputLocation
     */
    public function __construct(array $geocodeOutputLocation = array())
    {
        $this
            ->setGeocodeOutputLocation($geocodeOutputLocation);
    }
    /**
     * Get GeocodeOutputLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmGeocodeOutputLocation[]|null
     */
    public function getGeocodeOutputLocation()
    {
        return isset($this->GeocodeOutputLocation) ? $this->GeocodeOutputLocation : null;
    }
    /**
     * Set GeocodeOutputLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmGeocodeOutputLocation[] $geocodeOutputLocation
     * @return \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation
     */
    public function setGeocodeOutputLocation(array $geocodeOutputLocation = array())
    {
        foreach ($geocodeOutputLocation as $arrayOfGeocodeOutputLocationGeocodeOutputLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfGeocodeOutputLocationGeocodeOutputLocationItem instanceof \Pcm\StructType\PcmGeocodeOutputLocation) {
                throw new \InvalidArgumentException(sprintf('The GeocodeOutputLocation property can only contain items of \Pcm\StructType\PcmGeocodeOutputLocation, "%s" given', is_object($arrayOfGeocodeOutputLocationGeocodeOutputLocationItem) ? get_class($arrayOfGeocodeOutputLocationGeocodeOutputLocationItem) : gettype($arrayOfGeocodeOutputLocationGeocodeOutputLocationItem)), __LINE__);
            }
        }
        if (is_null($geocodeOutputLocation) || (is_array($geocodeOutputLocation) && empty($geocodeOutputLocation))) {
            unset($this->GeocodeOutputLocation);
        } else {
            $this->GeocodeOutputLocation = $geocodeOutputLocation;
        }
        return $this;
    }
    /**
     * Add item to GeocodeOutputLocation value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $item
     * @return \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation
     */
    public function addToGeocodeOutputLocation(\Pcm\StructType\PcmGeocodeOutputLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmGeocodeOutputLocation) {
            throw new \InvalidArgumentException(sprintf('The GeocodeOutputLocation property can only contain items of \Pcm\StructType\PcmGeocodeOutputLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GeocodeOutputLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GeocodeOutputLocation
     */
    public function getAttributeName()
    {
        return 'GeocodeOutputLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfGeocodeOutputLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
