<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDrawerType ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDrawerType
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfDrawerType extends AbstractStructArrayBase
{
    /**
     * The DrawerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DrawerType;
    /**
     * Constructor method for ArrayOfDrawerType
     * @uses PcmArrayOfDrawerType::setDrawerType()
     * @param string[] $drawerType
     */
    public function __construct(array $drawerType = array())
    {
        $this
            ->setDrawerType($drawerType);
    }
    /**
     * Get DrawerType value
     * @return string[]|null
     */
    public function getDrawerType()
    {
        return $this->DrawerType;
    }
    /**
     * Set DrawerType value
     * @uses \Pcm\EnumType\PcmDrawerType::valueIsValid()
     * @uses \Pcm\EnumType\PcmDrawerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $drawerType
     * @return \Pcm\ArrayType\PcmArrayOfDrawerType
     */
    public function setDrawerType(array $drawerType = array())
    {
        $invalidValues = array();
        foreach ($drawerType as $arrayOfDrawerTypeDrawerTypeItem) {
            if (!\Pcm\EnumType\PcmDrawerType::valueIsValid($arrayOfDrawerTypeDrawerTypeItem)) {
                $invalidValues[] = var_export($arrayOfDrawerTypeDrawerTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \Pcm\EnumType\PcmDrawerType::getValidValues())), __LINE__);
        }
        $this->DrawerType = $drawerType;
        return $this;
    }
    /**
     * Add item to DrawerType value
     * @uses \Pcm\EnumType\PcmDrawerType::valueIsValid()
     * @uses \Pcm\EnumType\PcmDrawerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pcm\ArrayType\PcmArrayOfDrawerType
     */
    public function addToDrawerType($item)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDrawerType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Pcm\EnumType\PcmDrawerType::getValidValues())), __LINE__);
        }
        $this->DrawerType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \Pcm\EnumType\PcmDrawerType::valueIsValid()
     * @param string $item
     * @return \Pcm\ArrayType\PcmArrayOfDrawerType
     */
    public function add($item)
    {
        if (!\Pcm\EnumType\PcmDrawerType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Pcm\EnumType\PcmDrawerType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DrawerType
     */
    public function getAttributeName()
    {
        return 'DrawerType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfDrawerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
