<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomPlaceLocation ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomPlaceLocation
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfCustomPlaceLocation extends AbstractStructArrayBase
{
    /**
     * The CustomPlaceLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCustomPlaceLocation[]
     */
    public $CustomPlaceLocation;
    /**
     * Constructor method for ArrayOfCustomPlaceLocation
     * @uses PcmArrayOfCustomPlaceLocation::setCustomPlaceLocation()
     * @param \Pcm\StructType\PcmCustomPlaceLocation[] $customPlaceLocation
     */
    public function __construct(array $customPlaceLocation = array())
    {
        $this
            ->setCustomPlaceLocation($customPlaceLocation);
    }
    /**
     * Get CustomPlaceLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCustomPlaceLocation[]|null
     */
    public function getCustomPlaceLocation()
    {
        return isset($this->CustomPlaceLocation) ? $this->CustomPlaceLocation : null;
    }
    /**
     * Set CustomPlaceLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmCustomPlaceLocation[] $customPlaceLocation
     * @return \Pcm\ArrayType\PcmArrayOfCustomPlaceLocation
     */
    public function setCustomPlaceLocation(array $customPlaceLocation = array())
    {
        foreach ($customPlaceLocation as $arrayOfCustomPlaceLocationCustomPlaceLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomPlaceLocationCustomPlaceLocationItem instanceof \Pcm\StructType\PcmCustomPlaceLocation) {
                throw new \InvalidArgumentException(sprintf('The CustomPlaceLocation property can only contain items of \Pcm\StructType\PcmCustomPlaceLocation, "%s" given', is_object($arrayOfCustomPlaceLocationCustomPlaceLocationItem) ? get_class($arrayOfCustomPlaceLocationCustomPlaceLocationItem) : gettype($arrayOfCustomPlaceLocationCustomPlaceLocationItem)), __LINE__);
            }
        }
        if (is_null($customPlaceLocation) || (is_array($customPlaceLocation) && empty($customPlaceLocation))) {
            unset($this->CustomPlaceLocation);
        } else {
            $this->CustomPlaceLocation = $customPlaceLocation;
        }
        return $this;
    }
    /**
     * Add item to CustomPlaceLocation value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmCustomPlaceLocation $item
     * @return \Pcm\ArrayType\PcmArrayOfCustomPlaceLocation
     */
    public function addToCustomPlaceLocation(\Pcm\StructType\PcmCustomPlaceLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmCustomPlaceLocation) {
            throw new \InvalidArgumentException(sprintf('The CustomPlaceLocation property can only contain items of \Pcm\StructType\PcmCustomPlaceLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomPlaceLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmCustomPlaceLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmCustomPlaceLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmCustomPlaceLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmCustomPlaceLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmCustomPlaceLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomPlaceLocation
     */
    public function getAttributeName()
    {
        return 'CustomPlaceLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfCustomPlaceLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
