<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generateProtocolXV2 Structs
 * Meta information extracted from the WSDL
 * - type: tns:generateProtocolXV2
 * @subpackage Structs
 */
class GenerateProtocolXV2 extends AbstractStructBase
{
    /**
     * The dpdServicesParamsCV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dpdServicesParamsCV1;
    /**
     * The outputDocFormatV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputDocFormatV1;
    /**
     * The outputDocPageFormatV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputDocPageFormatV1;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Structs\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generateProtocolXV2
     * @uses GenerateProtocolXV2::setDpdServicesParamsCV1()
     * @uses GenerateProtocolXV2::setOutputDocFormatV1()
     * @uses GenerateProtocolXV2::setOutputDocPageFormatV1()
     * @uses GenerateProtocolXV2::setAuthDataV1()
     * @param string $dpdServicesParamsCV1
     * @param string $outputDocFormatV1
     * @param string $outputDocPageFormatV1
     * @param \Structs\AuthDataV1 $authDataV1
     */
    public function __construct($dpdServicesParamsCV1 = null, $outputDocFormatV1 = null, $outputDocPageFormatV1 = null, \Structs\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setDpdServicesParamsCV1($dpdServicesParamsCV1)
            ->setOutputDocFormatV1($outputDocFormatV1)
            ->setOutputDocPageFormatV1($outputDocPageFormatV1)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get dpdServicesParamsCV1 value
     * @return string|null
     */
    public function getDpdServicesParamsCV1()
    {
        return $this->dpdServicesParamsCV1;
    }
    /**
     * Set dpdServicesParamsCV1 value
     * @param string $dpdServicesParamsCV1
     * @return \Structs\GenerateProtocolXV2
     */
    public function setDpdServicesParamsCV1($dpdServicesParamsCV1 = null)
    {
        // validation for constraint: string
        if (!is_null($dpdServicesParamsCV1) && !is_string($dpdServicesParamsCV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dpdServicesParamsCV1, true), gettype($dpdServicesParamsCV1)), __LINE__);
        }
        $this->dpdServicesParamsCV1 = $dpdServicesParamsCV1;
        return $this;
    }
    /**
     * Get outputDocFormatV1 value
     * @return string|null
     */
    public function getOutputDocFormatV1()
    {
        return $this->outputDocFormatV1;
    }
    /**
     * Set outputDocFormatV1 value
     * @uses \Enums\OutputDocFormatDSPEnumV1::valueIsValid()
     * @uses \Enums\OutputDocFormatDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputDocFormatV1
     * @return \Structs\GenerateProtocolXV2
     */
    public function setOutputDocFormatV1($outputDocFormatV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\OutputDocFormatDSPEnumV1::valueIsValid($outputDocFormatV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\OutputDocFormatDSPEnumV1', is_array($outputDocFormatV1) ? implode(', ', $outputDocFormatV1) : var_export($outputDocFormatV1, true), implode(', ', \Enums\OutputDocFormatDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->outputDocFormatV1 = $outputDocFormatV1;
        return $this;
    }
    /**
     * Get outputDocPageFormatV1 value
     * @return string|null
     */
    public function getOutputDocPageFormatV1()
    {
        return $this->outputDocPageFormatV1;
    }
    /**
     * Set outputDocPageFormatV1 value
     * @uses \Enums\OutputDocPageFormatDSPEnumV1::valueIsValid()
     * @uses \Enums\OutputDocPageFormatDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputDocPageFormatV1
     * @return \Structs\GenerateProtocolXV2
     */
    public function setOutputDocPageFormatV1($outputDocPageFormatV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\OutputDocPageFormatDSPEnumV1::valueIsValid($outputDocPageFormatV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\OutputDocPageFormatDSPEnumV1', is_array($outputDocPageFormatV1) ? implode(', ', $outputDocPageFormatV1) : var_export($outputDocPageFormatV1, true), implode(', ', \Enums\OutputDocPageFormatDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->outputDocPageFormatV1 = $outputDocPageFormatV1;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \Structs\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \Structs\AuthDataV1 $authDataV1
     * @return \Structs\GenerateProtocolXV2
     */
    public function setAuthDataV1(\Structs\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
