<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generatePackagesNumbersXV7 Structs
 * Meta information extracted from the WSDL
 * - type: tns:generatePackagesNumbersXV7
 * @subpackage Structs
 */
class GeneratePackagesNumbersXV7 extends AbstractStructBase
{
    /**
     * The openUMLFeV8
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openUMLFeV8;
    /**
     * The pkgNumsGenerationPolicyV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pkgNumsGenerationPolicyV1;
    /**
     * The langCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $langCode;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Structs\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generatePackagesNumbersXV7
     * @uses GeneratePackagesNumbersXV7::setOpenUMLFeV8()
     * @uses GeneratePackagesNumbersXV7::setPkgNumsGenerationPolicyV1()
     * @uses GeneratePackagesNumbersXV7::setLangCode()
     * @uses GeneratePackagesNumbersXV7::setAuthDataV1()
     * @param string $openUMLFeV8
     * @param string $pkgNumsGenerationPolicyV1
     * @param string $langCode
     * @param \Structs\AuthDataV1 $authDataV1
     */
    public function __construct($openUMLFeV8 = null, $pkgNumsGenerationPolicyV1 = null, $langCode = null, \Structs\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setOpenUMLFeV8($openUMLFeV8)
            ->setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1)
            ->setLangCode($langCode)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get openUMLFeV8 value
     * @return string|null
     */
    public function getOpenUMLFeV8()
    {
        return $this->openUMLFeV8;
    }
    /**
     * Set openUMLFeV8 value
     * @param string $openUMLFeV8
     * @return \Structs\GeneratePackagesNumbersXV7
     */
    public function setOpenUMLFeV8($openUMLFeV8 = null)
    {
        // validation for constraint: string
        if (!is_null($openUMLFeV8) && !is_string($openUMLFeV8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openUMLFeV8, true), gettype($openUMLFeV8)), __LINE__);
        }
        $this->openUMLFeV8 = $openUMLFeV8;
        return $this;
    }
    /**
     * Get pkgNumsGenerationPolicyV1 value
     * @return string|null
     */
    public function getPkgNumsGenerationPolicyV1()
    {
        return $this->pkgNumsGenerationPolicyV1;
    }
    /**
     * Set pkgNumsGenerationPolicyV1 value
     * @uses \Enums\PkgNumsGenerationPolicyV1::valueIsValid()
     * @uses \Enums\PkgNumsGenerationPolicyV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pkgNumsGenerationPolicyV1
     * @return \Structs\GeneratePackagesNumbersXV7
     */
    public function setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\PkgNumsGenerationPolicyV1::valueIsValid($pkgNumsGenerationPolicyV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\PkgNumsGenerationPolicyV1', is_array($pkgNumsGenerationPolicyV1) ? implode(', ', $pkgNumsGenerationPolicyV1) : var_export($pkgNumsGenerationPolicyV1, true), implode(', ', \Enums\PkgNumsGenerationPolicyV1::getValidValues())), __LINE__);
        }
        $this->pkgNumsGenerationPolicyV1 = $pkgNumsGenerationPolicyV1;
        return $this;
    }
    /**
     * Get langCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->langCode;
    }
    /**
     * Set langCode value
     * @param string $langCode
     * @return \Structs\GeneratePackagesNumbersXV7
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->langCode = $langCode;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \Structs\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \Structs\AuthDataV1 $authDataV1
     * @return \Structs\GeneratePackagesNumbersXV7
     */
    public function setAuthDataV1(\Structs\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
