<?php

namespace Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Packages Services
 * @subpackage Services
 */
class Packages extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named packagesPickupCallXV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\PackagesPickupCallXV2 $parameters
     * @return \Structs\PackagesPickupCallXV2Response|bool
     */
    public function packagesPickupCallXV2(\Structs\PackagesPickupCallXV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->packagesPickupCallXV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named packagesPickupCallXV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\PackagesPickupCallXV1 $parameters
     * @return \Structs\PackagesPickupCallXV1Response|bool
     */
    public function packagesPickupCallXV1(\Structs\PackagesPickupCallXV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->packagesPickupCallXV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named packagesPickupCallXV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\PackagesPickupCallXV4 $parameters
     * @return \Structs\PackagesPickupCallXV4Response|bool
     */
    public function packagesPickupCallXV4(\Structs\PackagesPickupCallXV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->packagesPickupCallXV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named packagesPickupCallXV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\PackagesPickupCallXV3 $parameters
     * @return \Structs\PackagesPickupCallXV3Response|bool
     */
    public function packagesPickupCallXV3(\Structs\PackagesPickupCallXV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->packagesPickupCallXV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\PackagesPickupCallXV1Response|\Structs\PackagesPickupCallXV2Response|\Structs\PackagesPickupCallXV3Response|\Structs\PackagesPickupCallXV4Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
