<?php

namespace Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import Services
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importDeliveryBusinessEventsV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ImportDeliveryBusinessEventsV1 $parameters
     * @return \Structs\ImportDeliveryBusinessEventsV1Response|bool
     */
    public function importDeliveryBusinessEventsV1(\Structs\ImportDeliveryBusinessEventsV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importDeliveryBusinessEventsV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\ImportDeliveryBusinessEventsV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
