<?php

namespace Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get Services
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getCourierOrderAvailabilityXV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\GetCourierOrderAvailabilityXV1 $parameters
     * @return \Structs\GetCourierOrderAvailabilityXV1Response|bool
     */
    public function getCourierOrderAvailabilityXV1(\Structs\GetCourierOrderAvailabilityXV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCourierOrderAvailabilityXV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\GetCourierOrderAvailabilityXV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
