<?php

namespace Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find Services
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findPostalCodeXV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\FindPostalCodeXV1 $parameters
     * @return \Structs\FindPostalCodeXV1Response|bool
     */
    public function findPostalCodeXV1(\Structs\FindPostalCodeXV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPostalCodeXV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\FindPostalCodeXV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
